﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.ClientService.Models
{
    [DataContract]
    public class CSyncedGameInstance : INotifyPropertyChanged
    {
        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        public CSyncedGameInstance()
        {
            Computers = new List<CSyncedComputer>();
            Addons = new List<CSyncedAddon>();
        }
         
        [DataMember]
        public int InstanceID
        {
            get;
            set;
        }
        
        [DataMember]
        public string InstanceName
        {
            get;
            set;
        }

        [DataMember]
        public long LastBackupFingerprint
        {
            get;
            set;
        }

        [DataMember]
        public long LastBackupScreenWidth
        {
            get;
            set;
        }

        [DataMember]
        public long LastBackupScreenHeight
        {
            get;
            set;
        }

        [DataMember]
        public DateTime LastBackupDate
        {
            get;
            set;
        }

        [DataMember]
        public int GameID
        {
            get;
            set;
        }

        [DataMember]
        public List<CSyncedComputer> Computers
        {
            get;
            set;
        }

        [DataMember]
        public List<CSyncedAddon> Addons
        {
            get;
            set;
        }
    }
}
