﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.ClientService.Models
{
    public class CTheme
    {
        public string ThemeToken
        {
            get;
            set;
        }

        public string ThemeName
        {
            get;
            set;
        }

        public string ThemeDirectory
        {
            get;
            set;
        }

        public string ThemeOverridesDirectory
        {
            get;
            set;
        }

        public string ThemeLabel
        {
            get;
            set;
        }

        public bool TransparentWindow
        {
            get;
            set;
        }

        public bool IsAdCampaign
        {
            get;
            set;
        }

        public CTheme(string themeToken, string themeName, string themeDirectory, string themeLabel, bool transparentWindow)
        {
            ThemeName = themeName;
            ThemeDirectory = themeDirectory;
            ThemeLabel = themeLabel;
            TransparentWindow = transparentWindow;
            ThemeToken = themeToken;
        }

        public CTheme(string themeToken, string themeName, string themeDirectory, string themeOverridesDirectory, string themeLabel, bool transparentWindow)
            : this(themeToken, themeName, themeDirectory, themeLabel, transparentWindow)
        {
            ThemeOverridesDirectory = themeOverridesDirectory;
        }

        public CTheme(bool isAdCampaign, string themeToken, string themeName, string themeDirectory, string themeOverridesDirectory, string themeLabel, bool transparentWindow)
            : this(themeToken, themeName, themeDirectory, themeOverridesDirectory, themeLabel, transparentWindow)
        {
            IsAdCampaign = isAdCampaign;
        }

        public CTheme(bool isAdCampaign, string themeToken, string themeName, string themeDirectory, string themeLabel, bool transparentWindow)
            : this(themeToken, themeName, themeDirectory, themeLabel, transparentWindow)
        {
            IsAdCampaign = isAdCampaign;
        }
    }
}
