﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using System.IO;

namespace Curse.ClientService.Models
{
    [MessageContract]
    public class CUserBackupMessage : IDisposable
    {
        [MessageHeader(MustUnderstand = true)]
        public string SessionID
        {
            get;
            set;
        }

        [MessageHeader(MustUnderstand = true)]
        public int InstanceID
        {
            get;
            set;
        }

        [MessageHeader(MustUnderstand = true)]
        public long Fingerprint
        {
            get;set;
        }

        [MessageHeader(MustUnderstand = true)]
        public int ScreenWidth
        {
            get;set;
        }

        [MessageHeader(MustUnderstand = true)]
        public int ScreenHeight
        {
            get;
            set;
        }

        [MessageBodyMember(Order = 1)]
        public Stream FileByteStream
        {
            get;set;
        }

        public void Dispose()
        {
            if (FileByteStream != null)
            {
                FileByteStream.Dispose();
                FileByteStream = null;
            }
        } 

    }
}
