﻿using System;
using System.Collections.Generic;
using System.Text;


namespace Curse.Contactology
{
    public static class Messenger
    {

        public static bool SendAccountActivation(bool sendThreaded, string username, string emailAddress, string activationLink, string activationCode)
        {
            Dictionary<int, string> customValues = new Dictionary<int, string>();
            customValues.Add((int)ECustomFields.Username, username);
            customValues.Add((int)ECustomFields.AuthActivationLink, activationLink);
            customValues.Add((int)ECustomFields.AuthActivationCode, activationCode);
            Mailer.SendCustomEmail(sendThreaded, (int)ETransactionalCampaign.AuthAccountActivation, emailAddress, customValues, ESendMode.Transactional);
            return true;
        }

        public static bool SendPremiumWelcome(bool sendThreaded, string username, string emailAddress)
        {
            Dictionary<int, string> customValues = new Dictionary<int, string>();
            customValues.Add((int)ECustomFields.Username, username);
            Mailer.SendCustomEmail(sendThreaded, (int)ETransactionalCampaign.PremiumWelcome, emailAddress, customValues, ESendMode.Transactional);
            return true;
        }

        public static bool SendCompedPremiumWelcome(bool sendThreaded, string username, string emailAddress)
        {
            Dictionary<int, string> customValues = new Dictionary<int, string>();
            customValues.Add((int)ECustomFields.Username, username);
            Mailer.SendCustomEmail(sendThreaded, (int)ETransactionalCampaign.CompedPremiumWelcome, emailAddress, customValues, ESendMode.Transactional);
            return true;
        }


        public static bool SendPasswordResetRequest(bool sendThreaded, string username, string emailAddress, string passwordResetLink)
        {
            Dictionary<int, string> customValues = new Dictionary<int, string>();
            customValues.Add((int)ECustomFields.Username, username);
            customValues.Add((int)ECustomFields.AuthPasswordResetLink, passwordResetLink);
            Mailer.SendCustomEmail(sendThreaded, (int)ETransactionalCampaign.AuthPasswordResetRequest, emailAddress, customValues, ESendMode.Transactional);
            return true;
        }

        public static bool SendPasswordResetConfirmation(bool sendThreaded, string username, string emailAddress, string passwordResetCode)
        {
            Dictionary<int, string> customValues = new Dictionary<int, string>();
            customValues.Add((int)ECustomFields.Username, username);
            customValues.Add((int)ECustomFields.AuthPasswordResetCode, passwordResetCode);
            Mailer.SendCustomEmail(sendThreaded, (int)ETransactionalCampaign.AuthPasswordResetConfirmation, emailAddress, customValues, ESendMode.Transactional);
            return true;
        }

        public static bool SendAddonFavoriteNotification(string username, string emailAddress, string addonFavoriteNotification)
        {
            Dictionary<int, string> customValues = new Dictionary<int, string>();
            customValues.Add((int)ECustomFields.Username, username);
            customValues.Add((int)ECustomFields.CurseAddonFavoriteNotification, addonFavoriteNotification);
            Mailer.SendCustomEmail(false, (int)EBulkCampaign.CurseAddonFavoriteNotification, emailAddress, customValues, ESendMode.Bulk);
            return true;
        }

        public static DynamicCampaign SendFavoriteNotification(List<AddonFavoriteSubscriber> subscribers, string listName, string senderName, string senderAddress, string subject, string htmlBody, string textBody)
        {

            Dictionary<string, Dictionary<int, string>> import = new Dictionary<string, Dictionary<int, string>>();            

            foreach (AddonFavoriteSubscriber subscriber in subscribers)
            {                
                Dictionary<int, string> customValues = new Dictionary<int, string>();
                customValues.Add((int)ECustomFields.Username, subscriber.Username);
                customValues.Add((int)ECustomFields.CurseAddonFavoriteNotification, subscriber.Links);                
                import.Add(subscriber.Email, customValues);
            }

            listName += " - " + DateTime.UtcNow.ToShortDateString() + " " + DateTime.UtcNow.ToShortTimeString();
            return Mailer.SendDynamicCampaign(listName, senderName, senderAddress, subject, htmlBody, textBody, import);           
        }

        public static bool SendSupportTicketReplyNotification(string username, string emailAddress, string ticketLink, string ticketName, string ticketReplier)
        {
            Dictionary<int, string> customValues = new Dictionary<int, string>();
            customValues.Add((int)ETransactionalCustomFields.Username, username);
            customValues.Add((int)ETransactionalCustomFields.SupportTicketLink, ticketLink);
            customValues.Add((int)ETransactionalCustomFields.SupportTicketName, ticketName);
            customValues.Add((int)ETransactionalCustomFields.SupportTicketReplier, ticketReplier);
            
            Mailer.SendCustomEmail(true, (int)ETransactionalCampaign.SupportTicketReplyNotification, emailAddress, customValues, ESendMode.Transactional);
            return true;
        }

    }
}
