﻿using System;

namespace Curse.DownloadSecurity.Tokens
{
    public static class SecureDownload
    {        
        public static string GetDownloadLinkWithIpRestriction(string baseLink, int pAddOnId, string pIpAddress)
        {

            // 5 ints from the time: Year, Month, Day, Hour, Minute            
            return baseLink + "?v=" + SecurityToken.GetHashCode(pIpAddress, pAddOnId, DateTime.UtcNow);
        }

        public static string GetDownloadLink(string baseLink, int pAddOnId, DateTime pDate)
        {
            // 5 ints from the time: Year, Month, Day, Hour, Minute            
            return baseLink + "?v2=" + SecurityToken.GetHashCode(pAddOnId, pDate);
        }

        public static string GetDownloadLink(string baseLink, int pAddOnId, string pIpAddress)
        {
            // 5 ints from the time: Year, Month, Day, Hour, Minute            
            return baseLink + "?v2=" + SecurityToken.GetHashCode(pAddOnId, DateTime.UtcNow);
        }
    }
}
