﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Curse.MurmurHash;

namespace Curse.DownloadSecurity.Tokens
{    
    public static class ThrottlingToken
    {

        private const int SEED = 1;

        /// <summary>
        /// Encodes the addon id and date into a murmurhashed string
        /// </summary>
        /// <param name="pAddOnId">The ProjectId of the addon to encode</param>
        /// <param name="pDate">The current date and time in UTC</param>
        /// <returns></returns>
        public static UInt32 GetHashCode(int pProfileId, DateTime pDate)
        {

            int[] hashVals = new int[6];

            // Date Parts
            hashVals[0] = pDate.Year;
            hashVals[1] = pDate.Month;
            hashVals[2] = pDate.Day;
            hashVals[3] = pDate.Hour;
            hashVals[4] = pDate.Minute;

            // File ID
            hashVals[5] = pProfileId;

            string hashCode = string.Empty;
            for (int i = 0; i < hashVals.Length; i++)
            {
                hashCode += hashVals[i];
            }
            byte[] hashBytes = System.Text.Encoding.ASCII.GetBytes(hashCode);

            return MurmurHash2.GetHashCode(ref hashBytes, hashBytes.Length, SEED);
        }
    }
}
