﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Curse.MurmurHash;
using Curse.DownloadSecurity.Throttling;
using System.Web;
using Curse.DownloadSecurity.Tokens;

namespace Curse.DownloadSecurity
{
    /// <summary>
    /// Utility class to offload some throttling specific functionality
    /// </summary>
    public class BitRateThrottling
    {
        #region Response String Constants

        public const string ResponseStringEnabled = "ResponseThrottler-Enabled";
        public const string ResponseStringInitialSendSize = "ResponseThrottler-InitialSendSize";
        public const string ResponseStringRate = "ResponseThrottler-Rate";
        public const string ResponseStringFileExtension = "ResponseThrottler-FileExtension";
        public const string ResponseStringEncodedBitRateKbps = "ResponseThrottler-EncodedBitRateKbps";
        public const string ResponseStringThrottleRatePercentage = "ResponseThrottler-ThrottleRatePercentage";
        public const string ResponseStringInitialBufferTimeSeconds = "ResponseThrottler-InitialBufferTimeSeconds";

        #endregion

        private const int SEED = 1;



        /// <summary>
        /// Create mapping of hashed values to profile enumeration values
        /// </summary>
        /// <param name="pIpAddress"></param>
        /// <param name="pProfileConfig"></param>
        /// <returns></returns>
        internal static Dictionary<UInt32, int> GetProfileHash(ThrottlingProfileConfigCollection pProfileConfig)
        {
            Dictionary<UInt32, int> profiles = new Dictionary<UInt32, int>(10);

            foreach (ThrottlingProfileConfigElement configElement in pProfileConfig)
            {
                profiles.Add(ThrottlingToken.GetHashCode(configElement.ID, DateTime.UtcNow), configElement.ID);
                profiles.Add(ThrottlingToken.GetHashCode(configElement.ID, DateTime.UtcNow.AddMinutes(-1)), configElement.ID);
            }
            return profiles;
        }

        /// <summary>
        /// Hash the parameters to compare against the querystring input
        /// </summary>
        /// <param name="pIpAddress"></param>
        /// <param name="pProfileId"></param>
        /// <returns></returns>
        [Obsolete("Due to issues with user IPs, please migrate to the version that does not encode the ip address")]
        public static UInt32 GetHashCode(string pIpAddress, int pProfileId)
        {
            string[] ipArray = pIpAddress.Split('.');
            if (ipArray.Length != 4)
            {
                return 0;
            }

            int[] hashVals = new int[5];

            // IP Parts
            hashVals[0] = int.Parse(ipArray[0]);
            hashVals[1] = int.Parse(ipArray[1]);
            hashVals[2] = int.Parse(ipArray[2]);
            hashVals[3] = 0;

            // Profile Part
            hashVals[4] = pProfileId;

            string hashCode = string.Empty;
            for (int i = 0; i < hashVals.Length; i++)
            {
                hashCode += hashVals[i];
            }
            byte[] hashBytes = System.Text.Encoding.ASCII.GetBytes(hashCode);

            return MurmurHash2.GetHashCode(ref hashBytes, hashBytes.Length, SEED);

        }

        /// <summary>
        /// Create mapping of hashed values to profile enumeration values
        /// </summary>
        /// <param name="pIpAddress"></param>
        /// <param name="pProfileConfig"></param>
        /// <returns></returns>
        [Obsolete("Due to issues with user IPs, please migrate to the version that does not encode the ip address")]
        internal static Dictionary<UInt32, int> GetProfileHash(string pIpAddress, ThrottlingProfileConfigCollection pProfileConfig)
        {
            Dictionary<UInt32, int> profiles = new Dictionary<UInt32, int>(10);

            foreach (ThrottlingProfileConfigElement configElement in pProfileConfig)
            {
                profiles.Add(GetHashCode(pIpAddress, configElement.ID), configElement.ID);
            }
            return profiles;
        }

        /// <summary>
        /// Sets the server variables for the request to the values indicated by the ThrottlingSettings
        /// </summary>
        /// <param name="pContext"></param>
        /// <param name="pSettings"></param>
        internal static void SendBitRateThrottlingServerVariables(HttpContext pContext, ThrottlingSettings pSettings)
        {
            if (pSettings.ThrottlerEnabled)
            {
                pContext.Request.ServerVariables.Set(ResponseStringEnabled, "1");
                if (pSettings.InitialSendSize != null)
                {
                    pContext.Request.ServerVariables.Set(ResponseStringInitialSendSize, pSettings.InitialSendSize.ToString());
                }
                if (pSettings.Rate != null)
                {
                    pContext.Request.ServerVariables.Set(ResponseStringRate, pSettings.Rate.ToString());
                }
                if (pSettings.FileExtension != null)
                {
                    pContext.Request.ServerVariables.Set(ResponseStringFileExtension, pSettings.FileExtension.ToString());
                }
                if (pSettings.EncodedBitRateKbps != null)
                {
                    pContext.Request.ServerVariables.Set(ResponseStringEncodedBitRateKbps, pSettings.EncodedBitRateKbps.ToString());
                }
                if (pSettings.ThrottleRatePercentage != null)
                {
                    pContext.Request.ServerVariables.Set(ResponseStringThrottleRatePercentage, pSettings.ThrottleRatePercentage.ToString());
                }

                if (pSettings.InitialBufferTimeSeconds != null)
                {
                    pContext.Request.ServerVariables.Set(ResponseStringInitialBufferTimeSeconds, pSettings.InitialBufferTimeSeconds.ToString());
                }
            }
            else
            {
                pContext.Request.ServerVariables.Set(ResponseStringEnabled, "0");
            }
        }
    }
}
