﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;

namespace Curse.DownloadSecurity.Throttling
{
    public class ThrottlingConfigurationHandler : ConfigurationSection
    {
        public static ThrottlingConfigurationHandler GetConfig()
        {
            return ConfigurationManager.GetSection("curse/throttling") as ThrottlingConfigurationHandler;
        }

        public ThrottlingConfigurationHandler() { }

        public ThrottlingConfigurationHandler(bool pThrottle)
        {
            Throttle = pThrottle;
        }

        [ConfigurationProperty("throttle", DefaultValue = "false", IsRequired = true)]
        public bool Throttle
        {
            get
            {
                return (bool)this["throttle"];
            }
            internal set
            {
                this["throttle"] = value;
            }
        }

        [
        ConfigurationProperty("profiles"),
        ConfigurationCollection(typeof(ThrottlingProfileConfigCollection), AddItemName = "profile")
        ]
        public ThrottlingProfileConfigCollection Profiles
        {
            get { return this["profiles"] as ThrottlingProfileConfigCollection; }
        }
    }

    public class ThrottlingProfileConfigCollection : ConfigurationElementCollection
    {
        public ThrottlingConfigurationHandler this[int index]
        {
            get
            {
                return base.BaseGet(index) as ThrottlingConfigurationHandler;
            }
            set
            {
                if (base.BaseGet(index) != null)
                {
                    base.BaseRemoveAt(index);
                }
                this.BaseAdd(index, value);
            }
        }

        protected override ConfigurationElement CreateNewElement()
        {
            return new ThrottlingProfileConfigElement();
        }

        protected override object GetElementKey(ConfigurationElement element)
        {
            return ((ThrottlingProfileConfigElement)element).ID;
        }
    }


    public class ThrottlingProfileConfigElement : ConfigurationElement
    {
        public ThrottlingProfileConfigElement() { }

        public ThrottlingProfileConfigElement(string pProfileLabel, ThrottlingProfiles pProfileID, long pMinimumRate, long pMaximumRate, TimeSpan pDuration)
        {
            Label = pProfileLabel;
            ID = (int)pProfileID;
            MinimumRate = pMinimumRate;
            MaximumRate = pMaximumRate;
            Duration = pDuration.Seconds;
        }

        public ThrottlingProfileConfigElement(string pProfileLabel, ThrottlingProfiles pProfileID, long pExplicitRate)
        {
            Label = pProfileLabel;
            ID = (int)pProfileID;
            ExplicitRate = pExplicitRate;
        }

        [ConfigurationProperty("label", IsRequired = false)]
        public string Label
        {
            get
            {
                return (string)this["label"];
            }
            internal set
            {
                this["label"] = value;
            }
        }

        [ConfigurationProperty("id", IsRequired = true)]
        public int ID
        {
            get
            {
                return (int)this["id"];
            }
            internal set
            {
                this["id"] = value;
            }
        }

        [ConfigurationProperty("initialSendSize", IsRequired = false)]
        public long InitialSendSize
        {
            get
            {
                return (long)this["initialSendSize"];
            }
            internal set
            {
                this["initialSendSize"] = value;
            }
        }

        [ConfigurationProperty("minimumRate", IsRequired = false)]
        public long MinimumRate
        {
            get
            {
                return (long)this["minimumRate"];
            }
            internal set
            {
                this["minimumRate"] = value;
            }
        }

        [ConfigurationProperty("maximumRate", IsRequired = false)]
        public long MaximumRate
        {
            get
            {
                return (long)this["maximumRate"];
            }
            internal set
            {
                this["maximumRate"] = value;
            }
        }

        [ConfigurationProperty("duration", IsRequired = false)]
        public int Duration
        {
            get
            {
                return (int)this["duration"];
            }
            internal set
            {
                this["duration"] = value;
            }
        }

        [ConfigurationProperty("explicitRate", IsRequired = false)]
        public long ExplicitRate
        {
            get
            {
                return (long)this["explicitRate"];
            }
            internal set
            {
                this["explicitRate"] = value;
            }
        }
    }
}
