﻿using System;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.GameServers
{
    [Serializable]
    [DataContract(Name = "gameRelease")]
    public class CGameRelease : INotifyPropertyChanged
    {
        #region Events
        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        public void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }
        #endregion

        [DataMember]
        public int ID { get; set; }

        [DataMember]
        public int SiteID { get; set; }

        [DataMember]
        public int GameID { get; set; }

        [DataMember]
        public int ClientGameID { get; set; }

        [DataMember]
        public string GameSlug { get; set; }

        [DataMember]
        public string Slug { get; set; }

        [DataMember]
        public string Title { get; set; }

        [DataMember]
        public DateTime ReleaseDate { get; set; }

        [DataMember]
        public int FileSize { get; set; }

        [DataMember]
        public EGameReleaseType ReleaseType { get; set; }

        [DataMember]
        public string ReleaseNotesLink { get; set; }

        [DataMember]
        public string ReleaseNotes { get; set; }

        [DataMember]
        public string DownloadURL { get; set; }

        private EGameReleaseState _state = EGameReleaseState.None;
        public EGameReleaseState State
        {
            get { return _state; }
            set { _state = value; OnPropertyChanged("State"); }
        }
    }    
}
