﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.GameServers
{
    [Serializable]
    [DataContract(Name = "gameServer")]
    public class CGameServer : INotifyPropertyChanged
    {
        #region Events
        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        public void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }
        #endregion

        private int _id;
        private int _gameId;
        private DateTime _dateCreated;
        private DateTime _dateModified;
        private DateTime _dateLastMined;
        private GameServerStatus _gameServerStatus;
        private byte[] _ipAddress;
        private int _port;
        private string _hostName;
        private string _title;
        private string _slug;
        private string _url;
        private int _maxPlayers;
        private int _playersOnline;
        private string _version;
        private long _latency;
        private DateTime _cacheDate;
        private bool _isFavorite;
        private string _countryCode;
        private int _queryPort;

        [NonSerialized]
        private string _moTD;
        [NonSerialized]
        private string _description;

        [DataMember]
        public int ID
        {
            get { return _id; }
            set
            {
                if (_id != value)
                {
                    _id = value;
                    OnPropertyChanged("ID");
                }
            }
        }

        [DataMember]
        public int GameID
        {
            get { return _gameId; }
            set
            {
                if (_gameId != value)
                {
                    _gameId = value;
                    OnPropertyChanged("GameID");
                }
            }
        }

        [DataMember]
        public string GameSlug { get; set; }

        [DataMember]
        public int GameServerDataSourceID { get; set; }

        [DataMember]
        public int GameServerTypeID { get; set; }

        [DataMember]
        public CGameServerType GameServerType { get; set; }

        [DataMember]
        public DateTime DateCreated
        {
            get { return _dateCreated; }
            set
            {
                if (_dateCreated != value)
                {
                    _dateCreated = value;
                    OnPropertyChanged("DateCreated");
                }
            }
        }

        [DataMember]
        public DateTime DateModified
        {
            get { return _dateModified; }
            set
            {
                if (_dateModified != value)
                {
                    _dateModified = value;
                    OnPropertyChanged("DateModified");
                }
            }
        }

        [DataMember]
        public DateTime DateLastMined
        {
            get { return _dateLastMined; }
            set
            {
                if (_dateLastMined != value)
                {
                    _dateLastMined = value;
                    OnPropertyChanged("DateLastMined");
                }
            }
        }

        [DataMember]
        public GameServerStatus GameServerStatus
        {
            get { return _gameServerStatus; }
            set
            {
                if (_gameServerStatus != value)
                {
                    _gameServerStatus = value;
                    OnPropertyChanged("GameServerStatus");
                }
            }
        }

        [DataMember]
        public byte[] IPAddress
        {
            get { return _ipAddress; }
            set
            {
                if (_ipAddress != value)
                {
                    _ipAddress = value;
                    OnPropertyChanged("IPAddress");
                }
            }
        }

        [DataMember]
        public int Port
        {
            get { return _port; }
            set
            {
                if (_port != value)
                {
                    _port = value;
                    OnPropertyChanged("Port");
                }
            }
        }

        [DataMember]
        public string HostName
        {
            get { return _hostName; }
            set
            {
                if (_hostName != value)
                {
                    _hostName = value;
                    OnPropertyChanged("HostName");
                }
            }
        }

        [DataMember]
        public string Title
        {
            get { return _title; }
            set
            {
                if (_title != value)
                {
                    _title = value;
                    OnPropertyChanged("Title");
                }
            }
        }

        [DataMember]
        public string Slug
        {
            get { return _slug; }
            set
            {
                if (_slug != value)
                {
                    _slug = value;
                    OnPropertyChanged("Slug");
                }
            }
        }

        [DataMember]
        public string Description
        {
            get { return _description; }
            set
            {
                if (_description != value)
                {
                    _description = value;
                    OnPropertyChanged("Description");
                }
            }
        }

        [DataMember]
        public string Url
        {
            get { return _url; }
            set
            {
                if (_url != value)
                {
                    _url = value;
                    OnPropertyChanged("Url");
                }
            }
        }

        [DataMember]
        public int MaxPlayers
        {
            get { return _maxPlayers; }
            set
            {
                if (_maxPlayers != value)
                {
                    _maxPlayers = value;
                    OnPropertyChanged("MaxPlayers");
                    OnPropertyChanged("AvailableSlots");
                }
            }
        }

        [DataMember]
        public int PlayersOnline
        {
            get { return _playersOnline; }
            set
            {
                if (_playersOnline != value)
                {
                    _playersOnline = value;
                    OnPropertyChanged("PlayersOnline");
                    OnPropertyChanged("AvailableSlots");
                }
            }
        }

        [DataMember]
        public string MoTD
        {
            get { return _moTD; }
            set
            {
                if (_moTD != value)
                {
                    _moTD = value;
                    OnPropertyChanged("MoTD");
                }
            }
        }

        [DataMember]
        public string Version
        {
            get { return _version; }
            set
            {
                if (_version != value)
                {
                    _version = value;
                    OnPropertyChanged("Version");
                }
            }
        }

        [DataMember]
        public long Latency
        {
            get { return _latency; }
            set
            {
                if (_latency != value)
                {
                    _latency = value;
                    OnPropertyChanged("Latency");
                }
            }
        }

        [DataMember]
        public DateTime CacheDate
        {
            get { return _cacheDate; }
            set
            {
                if (_cacheDate != value)
                {
                    _cacheDate = value;
                    OnPropertyChanged("CacheDate");
                }
            }
        }

        [DataMember]
        public bool IsFavorite
        {
            get { return _isFavorite; }
            set
            {
                if (_isFavorite != value)
                {
                    _isFavorite = value;
                    OnPropertyChanged("IsFavorite");
                }
            }
        }

        public int AvailableSlots
        {
            get
            {
                return MaxPlayers - PlayersOnline;
            }
        }

        [DataMember]
        public string CountryCode
        {
            get { return _countryCode; }
            set
            {
                if (_countryCode != value)
                {
                    _countryCode = value;
                    OnPropertyChanged("CountryCode");
                }
            }
        }

        [DataMember]
        public List<CGameServerPlayer> GameServerPlayers
        {
            get
            {
                return _gameServerPlayers;
            }
            set
            {
                _gameServerPlayers = value;
            }
        }
        [NonSerialized]
        private List<CGameServerPlayer> _gameServerPlayers = new List<CGameServerPlayer>();

        [DataMember]
        public List<CGameServerPlugin> GameServerPlugins
        {
            get
            {
                return _gameServerPlugins;
            }
            set
            {
                _gameServerPlugins = value;
            }
        }
        [NonSerialized]
        private List<CGameServerPlugin> _gameServerPlugins = new List<CGameServerPlugin>();

        [DataMember]
        public List<CGameServerProperty> GameServerProperties
        {
            get
            {
                return _gameServerProperties; 
            }
            set
            {
                _gameServerProperties = value;
            }
        }
        [NonSerialized]
        private List<CGameServerProperty> _gameServerProperties = new List<CGameServerProperty>();

        [DataMember]
        public List<CTag> GameServerTags
        {
            get
            { 
                return _gameServerTags; 
            }
            set
            { 
                _gameServerTags = value; 
            }
        }
        private List<CTag> _gameServerTags = new List<CTag>();

        [DataMember]
        public bool RespondsToPublicQuery { get; set; }

        [DataMember]
        public int PingFailedCount { get; set; }

        [DataMember]
        public DateTime DatePublicQueryLastChecked { get; set; }

        [DataMember]
        public EVerificationStatus VerificationStatus { get; set; }

        [DataMember]
        public int QueryPort
        {
            get { return _queryPort; }
            set { _queryPort = value; }
        }

        [DataMember]
        public int GameServerRatingID { get; set; }

        [DataMember]
        public CGameServerRating GameServerRating { get; set; }


        public bool IsQuerying { get; set; }
    }
}
