﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace Curse.GameServers
{
    [DataContract(Name = "gameServerDataSource")]
    public class CGameServerDataSource
    {
        [DataMember]
        public int ID { get; set; }

        [DataMember]
        public int GameID { get; set; }

        [DataMember]
        public CGameForServer Game { get; set; }
        
        [DataMember]
        public int GameServerProcessorID { get; set; }

        [DataMember]
        public CGameServerProcessor GameServerProcessor { get; set; }

        [DataMember]
        public string Name { get; set; }
        
        [DataMember]
        public string Configuration { get; set; }
        
        [DataMember]
        public ListDiscoveryType ListDiscoveryType { get; set; }

        [DataMember]
        public int DefaultPort { get; set; }

        [DataMember]
        public List<CGameServerPlugin> GameServerPlugins = new List<CGameServerPlugin>();

        [DataMember]
        public List<CGameServerType> GameServerTypes = new List<CGameServerType>();

        public Dictionary<int, CGameServerPlugin> GameServerPluginsByID { get; set; }
    }
}
