﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.GameServers
{
    public enum ListDiscoveryType
    {
        Auto = 1,
        Manual = 2
    }

    public enum GameServerStatus
    {
        Normal = 1,
        Deleted = 2,
        PingFailed = 3,
        Unresponsive = 4,
        NeedsVerification = 5
    }

    public enum FeedTimespan
    {
        Complete = -1,
        Hourly = 1,
        Daily = 24,
        Weekly = 168,
    }

    public enum EGameStatus
    {
        Normal = 1,
        Deleted = 2
    }

    public enum EServiceResponseStatus
    {
        Successful = 1,
        Failed,
        UnknownException,
        CreateGameServer_InvalidGameSlug,
        CreateGameServer_InvalidProcessorData,
        CreateGameServer_UnknownDataSource,
        CreateGameServer_IPAddressInUse,
        ClaimGameServer_InvalidGameServerId,
        SetServerVerification_UnknownDataSource,
        UpdateGameServerStatus_UnknownDataSource,
        UpdateGameServerCountry_UnknownCountryCode,
        UpdateGameServerQueryPort_UnknownDataSource
    }

    public enum EVerificationStatus
    {
        Pending = 1,
        Unverified = 2,
        Verified = 3
    }

    public enum EGameReleaseType
    {
        None = 0,
        Release = 1,
        PreRelease,
        Snapshot
    }

    public enum EGameServerRatingStatus
    {
        Normal = 1,
        Deleted = 2
    }

    public enum EGameReleaseState
    {
        None,
        Downloading,
        Error,
        Installed
    }
}
