﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.Logging
{
    public class LogEntry
    {

        public LogEntry()
        {
        }

        public LogEntry(LogEntryType type, int productID, string className, string methodName, string body)
        {
            ProductID = productID;
            Type = type;
            ClassName = className;
            MethodName = methodName;
            Body = body;
        }

        public int ID
        {
            get;
            set;
        }

        public int ProductID
        {
            get;
            set;
        }

        public DateTime DateReported
        {
            get;
            set;
        }

        public DateTime DateUpdated
        {
            get;
            set;
        }

        public DateTime? DateLastOccurred
        {
            get;
            set;
        }

        public LogEntryType Type
        {
            get;
            set;
        }

        public string Body
        {
            get;
            set;
        }

        public string ClassName
        {
            get;
            set;
        }

        public string MethodName
        {
            get;
            set;
        }

        public string RequestUrl
        {
            get;
            set;
        }

        public string IPAddress
        {
            get;
            set;
        }

        public string UserAgent
        {
            get;
            set;
        }

        public int ExceptionHashCode
        {
            get;
            set;
        }

        public string ExceptionMessage
        {
            get;
            set;
        }

        public string ExceptionStackTrace
        {
            get;
            set;
        }

        public int ExceptionCount
        {
            get;
            set;
        }




    }
}
