/****** Object:  Table [dbo].[LogEntry]    Script Date: 02/05/2010 09:29:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[LogEntry](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ProductID] [int] NOT NULL,
	[DateReported] [datetime] NOT NULL,
	[DateUpdated] [datetime] NOT NULL,
	[DateLastOccurred] [datetime] NULL,
	[TypeID] [int] NOT NULL,
	[Body] [nvarchar](max) NOT NULL,
	[ClassName] [nvarchar](64) NULL,
	[MethodName] [nvarchar](64) NULL,
	[RequestUrl] [nvarchar](max) NULL,
	[IPAddress] [nvarchar](15) NOT NULL,
	[UserAgent] [nvarchar](max) NOT NULL,
	[ExceptionHashCode] [int] NOT NULL,
	[ExceptionType] [nvarchar](128) NULL,
	[ExceptionMessage] [nvarchar](max) NULL,
	[ExceptionStackTrace] [nvarchar](max) NULL,
	[ExceptionCount] [int] NOT NULL,
 CONSTRAINT [PK_LogEntry] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[LogEntry] ADD  CONSTRAINT [DF_LogEntry_ProductID]  DEFAULT ((0)) FOR [ProductID]
GO

ALTER TABLE [dbo].[LogEntry] ADD  CONSTRAINT [DF_LogEntry_DateReported]  DEFAULT (getutcdate()) FOR [DateReported]
GO

ALTER TABLE [dbo].[LogEntry] ADD  CONSTRAINT [DF_LogEntry_DateUpdated]  DEFAULT (getutcdate()) FOR [DateUpdated]
GO

ALTER TABLE [dbo].[LogEntry] ADD  CONSTRAINT [DF_LogEntry_TypeID]  DEFAULT ((0)) FOR [TypeID]
GO

ALTER TABLE [dbo].[LogEntry] ADD  CONSTRAINT [DF_LogEntry_ExceptionHashCode]  DEFAULT ((0)) FOR [ExceptionHashCode]
GO

ALTER TABLE [dbo].[LogEntry] ADD  CONSTRAINT [DF_LogEntry_ExceptionCount]  DEFAULT ((0)) FOR [ExceptionCount]
GO