﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Build.Framework;
using Microsoft.Build.Utilities;
using System.Xml;
using System.Xml.Linq;

namespace Curse.MSBuild.Packer
{
    public class Packer : Task
    {

        /// <summary>
        /// Gets or sets the input files to pack.
        /// </summary>
        /// <value>The files to pack.</value>
        [Required]
        public ITaskItem[] InputFiles { get; set; }

        /// Gets or sets the input files to pack.
        /// </summary>
        /// <value>The files to pack.</value>
        public string Substitutions { get; set; }

        private string _outputFileName;

        /// <summary>
        /// Gets or sets the output filename
        /// </summary>
        public string OutputFileName
        {
            get { return _outputFileName; }
            set { _outputFileName = value; }
        }

        /// <summary>
        /// Mode of processing to use:
        /// 
        /// CSSMinify
        /// JSMinify
        /// None
        /// </summary>
        public string Processing { get; set; }

        /// <summary>
        /// Controls whether additional details are printed to the console
        /// </summary>
        public bool Verbose { get; set; }

        public override bool Execute()
        {
            List<string> inputFiles = new List<string>();
            foreach (ITaskItem item in InputFiles)
            {
                inputFiles.Add(item.ItemSpec);
            }

            IEnumerable<KeyValuePair<string, string>> parsedSubs = null;
            if (!string.IsNullOrEmpty(Substitutions))
            {
                XDocument doc = XDocument.Parse(Substitutions);
                
                parsedSubs = from sub in doc.Root.Elements()
                           select new KeyValuePair<string, string> (sub.Attribute("From").Value, sub.Attribute("To").Value);
                                              
            }

            Func<string, string> procDelegate = null;

            if (!string.IsNullOrEmpty(Processing)) {
                switch (Processing.ToLower())
                {
                    case "cssminify":
                        procDelegate = CSSMinifier.Minify;
                        break;
                    case "jsminify":
                        procDelegate = JavaScriptMinifier.Minify;
                        break;
                }
            }
            FileProcessor.Process(OutputFileName, inputFiles, parsedSubs, procDelegate, Verbose, AbsolutePathBase);

            return true;
        }

        /// <summary>
        /// If set, converts all relative paths to an absolute path starting at this directory
        /// For example, if AbsoultePathBase is Content, then c:\projects\example\Content\Skins\MySkin\... will become /Skins/MySkin/...
        /// </summary>
        public string AbsolutePathBase { get; set; }
    }
}
