var Geometry = {};

$(function() {
    if (window.screenLeft) { //IE mainly
        Geometry.getWindowX = function() { return window.screenLeft; };
        Geometry.getWindowY = function() { return window.screenTop; };
    } else if (window.screenX) { //FF mainly
        Geometry.getWindowX = function() { return window.screenX; };
        Geometry.getWindowY = function() { return window.screenY; };
    }
    
    if (window.innerWidth) { //All but IE
        Geometry.getViewportWidth    = function() { return window.innerWidth; };
        Geometry.getViewportHeight   = function() { return window.innerHeight; };
        Geometry.getHorizontalScroll = function() { return window.pageXOffset; };
        Geometry.getVerticalScroll   = function() { return window.pageYOffset; };
    } else if (document.documentElement && document.documentElement.clientWidth) { // IE6 w/ doctype
        Geometry.getViewportWidth    = function() { return document.documentElement.clientWidth; };
        Geometry.getViewportHeight   = function() { return document.documentElement.clientHeight; };
        Geometry.getHorizontalScroll = function() { return document.documentElement.scrollLeft; };
        Geometry.getVerticalScroll   = function() { return document.documentElement.scrollTop; };
    } else if (document.body.clientWidth) { // IE4,5,6(w/o doctype)
        Geometry.getViewportWidth    = function() { return document.body.clientWidth; };
        Geometry.getViewportHeight   = function() { return document.body.clientHeight; };
        Geometry.getHorizontalScroll = function() { return document.body.scrollLeft; };
        Geometry.getVerticalScroll   = function() { return document.body.scrollTop; };
    }
    
    if (document.documentElement && document.documentElement.scrollWidth) {
        Geometry.getDocumentWidth  = function() { return document.documentElement.scrollWidth; };
        Geometry.getDocumentHeight = function() { return document.documentElement.scrollHeight; };
    } else if (document.body.scrollWidth) {
        Geometry.getDocumentWidth  = function() { return document.body.scrollWidth; };
        Geometry.getDocumentHeight = function() { return document.body.scrollHeight; };
    }
    
    Geometry.getXY = function(element) {
        var el = element.get ? element.get(0) : element;
        if (el.parentNode == null || el.offsetParent == null || $(el).css('display') == 'none') { return false; }
    
        if (el.getBoundingClientRect) { // IE
            var box = el.getBoundingClientRect();
            var doc = document;
            if ( $(el, document).length > 0 && parent.document != document) {// might be in a frame, need to get its scroll
                doc = parent.document;
                if ( $(doc.documentElement, el).length > 1 ) return false;
            }
            return [box.left + Math.max(doc.documentElement.scrollLeft, doc.body.scrollLeft), box.top + Math.max(doc.documentElement.scrollTop, doc.body.scrollTop)];
        } else {
            var pos = [el.offsetLeft, el.offsetTop];
            var parentNode = el.offsetParent;
            if (parentNode != el) {
                while (parentNode) {
                    pos[0] += parentNode.offsetLeft;
                    pos[1] += parentNode.offsetTop;
                    parentNode = parentNode.offsetParent;
                }
            }
            if ($.browser.safari && $(el).css('position') == 'absolute' ) { // safari doubles in some cases
                pos[0] -= document.body.offsetLeft;
                pos[1] -= document.body.offsetTop;
            }
            
            if (el.parentNode) { parentNode = el.parentNode; } else { parentNode = null; }
    
            while (parentNode && parentNode.tagName.toUpperCase() != 'BODY' && parentNode.tagName.toUpperCase() != 'HTML') 
            { // account for any scrolled ancestors
                if ($(parentNode).css('display') != 'inline') { // work around opera inline scrollLeft/Top bug
                    pos[0] -= parentNode.scrollLeft;
                    pos[1] -= parentNode.scrollTop;
                }
                if (parentNode.parentNode) { parentNode = parentNode.parentNode; } else { parentNode = null; }
            };
            return pos;
        }
    };
    
    Geometry.getX = function(element) { return Geometry.getXY(element)[0]; };
    Geometry.getY = function(element) { return Geometry.getXY(element)[1]; };
    
    Geometry.getConstrainedDimensions = function(baseWidth, baseHeight, preserve) {
        var vh = Geometry.getViewportHeight(); var vw = Geometry.getViewportWidth();  
        var result = new Array(baseWidth, baseHeight);
        if (vh < (result[0] + 60)){
            result[1] = vh - 60;     
            if (preserve) result[0] = baseWidth * (result[1]/ baseHeight);     
        }  
        
        if (vw < (result[1] + 60)) {  
            result[0] = vw - 60;
            if (preserve) result[1] = baseHeight *(result[0]/ baseWidth);
        }
        return result;    
    };
});