﻿Curse = {};
Curse.Utils = 
{
    localTime: null,
    getLocalTime: function()
    {
        if(Curse.Utils.localTime != null)
        {
            return Curse.Utils.localTime;
        }        
        Curse.Utils.localTime = new Date().getTime();
        return Curse.Utils.localTime;
        
    },    
    modulus: function(divisee,base)
    {
	    return Math.round(divisee - (Math.floor(divisee/base)*base));
    },
    getDateWithDateSince: function(epoch)
    {
        localDate = new Date(epoch);
        return localDate.toLocaleString() + " (" + Curse.Utils.getDateSince(epoch) + ")";
    },    
    getDateSince: function(epoch)
    {                
        localDate = new Date(epoch);                                
        var shortFriendlyTime;
        var timeDifferenceMinutes = parseInt((Curse.Utils.getLocalTime() - localDate.getTime()) / 1000 / 60);
        var timeDifferenceHours = parseInt(timeDifferenceMinutes / 60);
        var timeDifferenceDays = parseInt(timeDifferenceHours / 24);
        
        if(timeDifferenceMinutes <= 1)
        {
            return Curse.Localization.format("date_minuteago");
        }
        
        if(timeDifferenceHours < 1)
        {
            return Curse.Localization.format("date_minutesago", timeDifferenceMinutes);
        }        
        
        if(timeDifferenceDays < 1)
        {
            var extraMins = Curse.Utils.modulus(timeDifferenceMinutes,60);
            if(timeDifferenceHours == 1)
            {
            
                return Curse.Localization.format("date_hourago", timeDifferenceHours, extraMins);            
            }
            else
            {
                return Curse.Localization.format("date_hoursago", timeDifferenceHours, extraMins);            
            }
            
        }
        if (timeDifferenceDays < 2)
        {
            return Curse.Localization.format("date_yesterday", timeDifferenceDays);                        
        }
        if (timeDifferenceDays < 7)
        {
            return Curse.Localization.format("date_daysago", timeDifferenceDays);                                    
        }
        if (timeDifferenceDays < 14)
        {
            return Curse.Localization.format("date_weekago");
        }
        if (timeDifferenceDays < 28)
        {            
            var weeks = Math.round(timeDifferenceDays / 7);
            return Curse.Localization.format("date_weeksago", weeks);
        }
        if (timeDifferenceDays < 60)
        {
            return Curse.Localization.format("date_lastmonth");
        }
        if (timeDifferenceDays < 365)
        {
            var months = Math.round(timeDifferenceDays / 30);
            return Curse.Localization.format("date_monthsago", months);
        }
        if (timeDifferenceDays >= 365)
        {
            var years = Math.round(timeDifferenceDays / 365);
            return Curse.Localization.format("date_yearsago", years);            
        }

        return Curse.Localization.format("date_yearsago");        
    },
    getRenderTime: function(epoch)
    {
        localDate = new Date(epoch);                                            
        var timeDifferenceSeconds = parseInt((Curse.Utils.getLocalTime() - localDate.getTime()) / 1000);
        var cacheWarning = "";
        if(timeDifferenceSeconds < 5)
        {
            cacheWarning = " <blink><font color=\"red\">Possible Caching Issue!</font></blink>";
        }
        return document.write(localDate.toLocaleString() + " (" + timeDifferenceSeconds + " seconds ago)" + cacheWarning);
    },
    cookiesDisabled: function()
    {        
        Curse.Utils.setDomainCookie("_cookieTest", true);
        return Curse.Utils.getCookie("_cookieTest") == null;
        
    },
    setDomainCookie: function(name, value, expires)
    {
        var tld = Curse.Utils.getCurrentDomain();
        Curse.Utils.setCookie(name, value, null, null, null, "/", tld, null, expires);    
    },
    getCurrentDomain: function()
    {
        var host = self.location.host;
        var segments = host.split(".");
        var tld = segments[segments.length-2] + "." + segments[segments.length-1]; 
        return tld;
    },
    setCookie: function ( name, value, exp_y, exp_m, exp_d, path, domain, secure, expires )
    {
        var cookie_string = name + "=" + escape ( value );
        if(expires==null)
        {
            expires = new Date();
        }
        
        if ( exp_y )
        {
            if(exp_m = null)
            {
                exp_m = 1;
            }
            if(exp_d = null)
            {
                exp_m = 1;
            }      
            expires.setTime (expires.getTime() + (1000 * 60 * 60 * 24 * 31));        
        }
        else
        {
            expires.setDate(expires.getDate()+365);
        }
        cookie_string += "; expires=" + expires.toGMTString();
        if ( path )
            cookie_string += "; path=" + escape ( path );

        if ( domain )
            cookie_string += "; domain=" + escape ( domain );

        if ( secure )
            cookie_string += "; secure";

        document.cookie = cookie_string;
    },
    getCookie:function ( cookie_name )
    {
      var results = document.cookie.match ( cookie_name + '=(.*?)(;|$)' );

      if ( results )
        return ( unescape ( results[1] ) );
      else
        return null;
    },
    deleteCookie: function( name, path, domain )
    {     
        var curVal=Curse.Utils.getCookie(name);        
        if(curVal)
        {        
            document.cookie = name + "=" + curVal + ";expires=Thu, 01-Jan-1970 00:00:01 GMT;path=/";
        }
    },
    getEvent: function (e)
    {
        if(!Curse.Browser.ie && !e)
        {		 
            return null;
        }
        if(!e)
        {
            e=window.event;
            if(!e)
            {
                return null;
            }
        }
        e._button=e.which?e.which:e.button;
        e._target=e.target?e.target:e.srcElement;
        e._relatedTarget=e.relatedTarget?e.relatedTarget:e.toElement;
        return e;
    },
    cancelBubbling: function(e)
    {
        if(Curse.Browser.ie)
        {    
            e = window.event;
            e.cancelBubble = true;
        }
        else
        {            
            if(!e)
            {
                return;
            }
            e.stopPropagation();
        }
    },
    getSlug: function(stringToSlug)
    {
        stringToSlug = stringToSlug.toLowerCase();
        while(stringToSlug.match(/[^A-Za-z0-9_\-\s]+/) != null)
        {
            stringToSlug = stringToSlug.replace(/[^A-Za-z0-9_\-\s]/, "");
        }
        var slug_array = stringToSlug.split(" ");
        stringToSlug = slug_array.join("-");
        return stringToSlug;
    }
};

function cg_args(a)
{
    var r=[];
    for(var i=0,len=a.length;i<len;++i)
    {
        r.push(a[i]);
    }
    return r;
}

Function.prototype.bind=function() {
    var ref=this;
    var args=cg_args(arguments);
    var object=args.shift();
    return function() {
        return ref.apply(object,args.concat(cg_args(arguments)));
    };
};
if (!Array.indexOf) {
    Array.prototype.indexOf = function(obj) {
        for(var i=0; i<this.length; i++) {
            if(this[i]==obj) {
                return i;
            }
        }
    }
};
