﻿Curse.Session = {
    authenticated: function() {
        return (Curse.User.username != null
                && Curse.User.username != ""
                && Curse.Utils.getCookie("Network.Session") != null
                && Curse.Utils.getCookie("Network.Lock") != null
                && Curse.Utils.getCookie("Network.TimeLock") != null
                && Curse.Utils.getCookie(".CurseAuth") != null
                );
    },
    initialize: function() {
        // For users who have disabled cookies, don't try to initialize a session:  
        if (Curse.Utils.cookiesDisabled()) {
            return;
        }

        var sessionTimeout = 1000 * 60 * 10;
        setTimeout(Curse.Session.reset, sessionTimeout);
        var sessionid = Curse.Utils.getCookie("Network.Session");
        var locked = Curse.Utils.getCookie("Network.Lock");
        var timeLocked = Curse.Utils.getCookie("Network.TimeLock");

        if (sessionid != null && locked != null && timeLocked != null) {
            Curse.Session.onAutoLogin();
            return;
        }
        var exp = new Date();
        var minutes = exp.getMinutes();
        minutes += 20;
        exp.setMinutes(minutes);
        Curse.Utils.setDomainCookie("Network.TimeLock", "1", exp);
        var iframe = document.createElement("IFRAME");
        iframe.src = "/user/NetworkCookie/ajaxSession.aspx";
        iframe.style.display = "none";
        document.body.appendChild(iframe);
    },
    reset: function() {
        Curse.Utils.deleteCookie("Network.Lock");
    },
    handleLogin: function(status) {
        Curse.Session.onLogin(status);
    },
    onLogin: function(status) {
        Curse.User.initialize();
        Curse.Session.drawUser();
    },
    onAutoLogin: function() {
        Curse.Session.drawUser();
    },
    myBase: "http://my." + Curse.Utils.getCurrentDomain() + "/",
    drawUser: function() {
        if (!Curse.Session.authenticated()) {
            return;
        }
        Curse.Session.drawNewWelcomeBox();
    },
    getNewWelcomeBox: function() {
        if (!Curse.Session.authenticated()) {
            return;
        }
        var container = document.createElement("div");
        container.className = "stuff";

        // Logout Container
        var logoutContainer = document.createElement("span");
        logoutContainer.className = "action";
        var logoutLink = document.createElement("a");
        logoutLink.href = "/logout.aspx";
        logoutLink.appendChild(document.createTextNode("Logout"));
        logoutContainer.appendChild(logoutLink);
        container.appendChild(logoutContainer);


        // User Menu
        var userMenuContainer = document.createElement("dl");
        userMenuContainer.className = "plain last clear";

        // Username
        var usernameContainer = document.createElement("dt");
        var usernameLabel = document.createElement("h3");
        usernameContainer.appendChild(usernameLabel);

        var usernameLink = document.createElement("a");
        usernameLink.href = Curse.Session.myBase + "my/";
        usernameLink.appendChild(document.createTextNode(Curse.User.username));
        usernameLabel.appendChild(usernameLink);
        container.appendChild(usernameContainer);

        // Avatar container
        var avatarContainer = document.createElement("dd");
        avatarContainer.className = "first";
        userMenuContainer.appendChild(avatarContainer);

        var avatarLink = document.createElement("a");
        if (Curse.User.roleName) {
            avatarLink.className = "avatar role-" + Curse.User.roleName.toLowerCase();
        }
        else {
            avatarLink.className = "avatar";
        }
        avatarLink.href = Curse.Session.myBase + "my/";
        avatarContainer.appendChild(avatarLink);

        var avatar = document.createElement("img");
        avatar.style.borderWidth = "0px";
        avatar.style.maxHeight = "180px";
        avatar.style.maxWidth = "100px";
        if (!Curse.User.avatarUrl || Curse.User.avatarUrl == "") {
            avatar.src = "/Themes/Common/v6/images/profile-lg.png";
        }
        else {
            avatar.src = Curse.User.avatarUrl;
        }
        avatarLink.appendChild(avatar);

        //        // Profile
        var profileContainer = document.createElement("dd");
        userMenuContainer.appendChild(profileContainer);
        var updateLink = document.createElement("a");
        updateLink.className = "profile"
        updateLink.href = Curse.Session.myBase + "my/";
        updateLink.appendChild(document.createTextNode("Profile"));
        profileContainer.appendChild(updateLink);


        //Inbox
        var inboxContainer = document.createElement("dd");
        userMenuContainer.appendChild(inboxContainer);
        var inboxLink = document.createElement("a");
        inboxLink.className = "mail";
        inboxLink.href = "/user/conversations/default.aspx";
        inboxLink.appendChild(document.createTextNode("Inbox"));
        inboxLink.appendChild(document.createTextNode("(" + Curse.User.messageCount + ")"));

        inboxContainer.appendChild(inboxLink);

        //Favorites
        var inboxContainer = document.createElement("dd");
        inboxContainer.className = "last";
        userMenuContainer.appendChild(inboxContainer);
        var inboxLink = document.createElement("a");
        inboxLink.className = "favorites";
        inboxLink.href = Curse.Session.myBase + "my/favorites.aspx";
        inboxLink.appendChild(document.createTextNode("Favorites"));
        inboxContainer.appendChild(inboxLink);

        container.appendChild(userMenuContainer);

        // Curse Menu
        if (Curse.User.inRole("Curse") || Curse.User.inRole("Moderator")) {
            var adminMenuContainer = document.createElement("dl");
            adminMenuContainer.className = "plain last clear admin-menu";
            this.addAdminMenu(adminMenuContainer);
            $(document).ready(function() {
                $('#login').hover(
			        function() { $('dl.admin-menu').css('display', 'block'); },
			        function() { $('dl.admin-menu').css('display', 'none'); });
            });
            container.appendChild(adminMenuContainer);
        }

        return container;
    },
    drawNewWelcomeBox: function() {
        if (Curse.Session.welcomeBoxDrawn) {
            return;
        }
        // Homepage welcome box:
        var loginBox = document.getElementById("login");
        if (!loginBox) {
            return;
        }
        loginBox.innerHTML = "";
        loginBox.appendChild(Curse.Session.getNewWelcomeBox());
    },
    quickDrawNewWelcomeBox: function() {
        if (!Curse.Session.authenticated()) {
            return;
        }

        document.write("<style>#login-loggedoff{display:none};</style>");
        var welcomeBox = Curse.Session.getNewWelcomeBox();
        document.write("<div id=\"login-loggedin\" class=\"stuff\">" + welcomeBox.innerHTML + "</div>");
        Curse.Session.welcomeBoxDrawn = true;


    },
    addAdminMenu: function(container) {
        var linkContainer = document.createElement("dd");
        linkContainer.className = "admin-menu";
        var reportLink = document.createElement("a");
        reportLink.href = "/forums/1.aspx";
        reportLink.appendChild(document.createTextNode("Reports"));
        linkContainer.appendChild(reportLink);
        container.appendChild(linkContainer);

        var linkContainer = document.createElement("dd");
        linkContainer.className = "admin-menu";
        var reportLink = document.createElement("a");
        reportLink.href = "/controlpanel";
        reportLink.appendChild(document.createTextNode("Control Panel"));
        linkContainer.appendChild(reportLink);
        container.appendChild(linkContainer);

    }


};