﻿Curse.Ajax = {
    http: false,
    format: 'text',
    callback: function(data) { },
    handler: false,
    error: false,
    opt: new Object(),
    getHTTPObject: function() {
        var http = false;
        if (typeof ActiveXObject != 'undefined') {
            try { http = new ActiveXObject("Msxml2.XMLHTTP"); }
            catch (e) {
                try { http = new ActiveXObject("Microsoft.XMLHTTP"); }
                catch (E) { http = false; }
            }
        } else if (XMLHttpRequest) {
            try { http = new XMLHttpRequest(); }
            catch (e) { http = false; }
        }
        return http;
    },
    load: function(url, callback, format, method, allowCache, queueFunction, queueFunctionArgs, callbackHost) {
        this.init();
        if (!this.http || !url) return;
        if (this.http.overrideMimeType) this.http.overrideMimeType('text/xml');

        this.queueFunction = queueFunction;
        this.queueFunctionArgs = queueFunctionArgs;
        this.callback = callback;
        this.callbackHost = callbackHost;        
        if (!method) var method = "GET";
        if (!format) var format = "text";
        this.format = format.toLowerCase();
        method = method.toUpperCase();
        var ths = this;
        if (!allowCache) {
            var now = "uid=" + new Date().getTime();
            url += (url.indexOf("?") + 1) ? "&" : "?";
            url += now;
        }

        var parameters = null;

        if (method == "POST") {
            var parts = url.split("\?");
            url = parts[0];
            parameters = parts[1];
        }

        this.http.open(method, url, true);

        if (method == "POST") {
            this.http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            this.http.setRequestHeader("Content-length", parameters.length);
            if (!Curse.Browser.ie) {
                this.http.setRequestHeader("Connection", "close");
            }
        }

        if (this.handler) {
            this.http.onreadystatechange = this.handler;
        }
        else {
            this.http.onreadystatechange = function() {
                if (!ths) return;
                var http = ths.http;
                if (http.readyState == 4) {
                    if (http.status == 200) {
                        var result = "";
                        if (http.responseText) result = http.responseText;
                        if (ths.format.charAt(0) == "j") {
                            result = result.replace(/[\n\r]/g, "");
                            result = eval('(' + result + ')');

                        }
                        else if (ths.format.charAt(0) == "x") {
                            result = http.responseXML;
                        }

                        if (ths.queueFunction) {
                            ths.queueFunction(result, ths.callback, ths.queueFunctionArgs);
                        }
                        else if (ths.callback) {
                            if (ths.callbackHost) {
                                ths.callback.bind(ths.callbackHost, result)();
                            }
                            else {
                                ths.callback(result);
                            }

                        }
                    }
                    else {
                        if (ths.opt.loadingIndicator) document.getElementsByTagName("body")[0].removeChild(ths.opt.loadingIndicator); //Remove the loading indicator
                        if (ths.opt.loading) document.getElementById(ths.opt.loading).style.display = "none"; //Hide the given loading indicator.						
                        if (ths.error) ths.error(http.status);
                    }
                }
            }
        }
        this.http.send(parameters);
    },
    bind: function(user_options) {
        var opt = {
            'url': '',
            'onSuccess': false,
            'onError': false,
            'format': "text",
            'method': "GET",
            'update': "",
            'loading': "",
            'loadingIndicator': ""
        }
        for (var key in opt) {
            if (user_options[key]) {
                opt[key] = user_options[key];
            }
        }
        this.opt = opt;
        if (!opt.url) return;
        if (opt.onError) this.error = opt.onError;

        var div = false;
        if (opt.loadingIndicator) {
            div = document.createElement("div");
            div.setAttribute("style", "position:absolute;top:0px;left:0px;");
            div.setAttribute("class", "loading-indicator");
            div.innerHTML = opt.loadingIndicator;
            document.getElementsByTagName("body")[0].appendChild(div);
            this.opt.loadingIndicator = div;
        }
        if (opt.loading) document.getElementById(opt.loading).style.display = "block"; //Show the given loading indicator.

        this.load(opt.url, function(data) {
            if (opt.onSuccess) opt.onSuccess(data);
            if (opt.update) document.getElementById(opt.update).innerHTML = data;

            if (div) document.getElementsByTagName("body")[0].removeChild(div); //Remove the loading indicator
            if (opt.loading) document.getElementById(opt.loading).style.display = "none"; //Hide the given loading indicator.
        }, opt.format, opt.method);
    },
    init: function() { this.http = this.getHTTPObject(); }
};