﻿Curse.Editor = function(notifyDiv) {
    this.tinyMCEBuffers = new Object();
    this.tinyMCECharCounts = new Object();
    this.maxChars = 0;
    this.notifyDiv = notifyDiv;

    // Event fired when something in TinyMCE changes such as when an undo
    // level is added like after a copy/paste.
    this.TinyMceOnChange = function(inst) {
        this.TinyMceCheckContentLength(inst.id);
    }

    // Event fired for any normal UI event such as a key or mouse press.
    this.TinyMceEventHandler = function(e) {
        switch (e.type) {
            case 'keyup':
                this.maxChars = tinyMCE.activeEditor.getParam("max_length");
                this.TinyMceOnChange(tinyMCE.activeEditor);
                break;
        }
        return true;
    }

    this.TinyMceCheckContentLength = function(strEditorId) {
        var editorInstance = tinyMCE.get(strEditorId);
        if (editorInstance == null || editorInstance == undefined) { alert('NO EDITOR'); }

        var contentContainer = editorInstance.getBody();
        if (contentContainer == null || contentContainer == undefined) { alert('NO CONTENT CONTAINER'); }

        var strContent = contentContainer.innerHTML;
        var intContentLength = strContent.length;
        var intCharCount = Curse.Editor.Utils.stripHtmlTags(strContent).length;

        if (intCharCount <= this.maxChars) {
            // The user has not passed the maximum amount of content in the editor...

            // Save away the current contents in case they have typed too much and we have to
            // revert back to this state.
            this.tinyMCEBuffers[strEditorId] = strContent;
            this.tinyMCECharCounts[strEditorId] = intCharCount;
            this.notifyDiv.html('You have ' + (this.maxChars - intCharCount) + ' characters remaining.').css("color", "black").css("font-weight", "normal");
        } else {
            // The user has put more than the maximum amount of content in the editor...
            // We must now revert back to the last good contents that we had for the editor,
            // or else whatever fits if we never had anything saved from there.
            var bm = editorInstance.selection.getBookmark(); // Stores a bookmark of the current selection
            editorInstance.setContent((this.tinyMCEBuffers[strEditorId]) ? this.tinyMCEBuffers[strEditorId] : strContent.substring(0, this.maxChars - 10));
            var intDelta = intCharCount - this.tinyMCECharCounts[strEditorId];
            if (bm['start'] && bm['start'] > intDelta) {
                bm['start'] -= intDelta;
                bm['end'] = bm['start'];
            }
            editorInstance.selection.moveToBookmark(bm); // Restore the selection bookmark
            this.notifyDiv.html("You have exceeded the maximum number of characters.").css("color", "red").css("font-weight", "bold");
        }
    }
}

Curse.Editor.PlainText = function(textArea, maxChars, notifyDiv) {

    this.textArea = textArea;
    this.maxChars = maxChars;
    this.notifyDiv = notifyDiv;
    this.charBuffer = textArea.val();

    this.limitChars = function() {
        var text = Curse.Editor.Utils.stripHtmlTags(this.textArea.val());
        var textlength = text.length;
        if (textlength > this.maxChars) {
            this.notifyDiv.html("You have exceeded the maximum number of characters.").css("color", "red").css("font-weight", "bold");
            this.textArea.val(this.charBuffer);
            return false;
        }
        else {
            this.charBuffer = textArea.val();
            this.notifyDiv.html('You have ' + (this.maxChars - textlength) + ' characters remaining.').css("color", "black").css("font-weight", "normal");
            return true;
        }
    }
};

Curse.Editor.Utils = {
    // Strips all html tags from a given string, leaving only plain text
    stripHtmlTags : function(strContent) { return strContent.replace(/(<([^>]+)>)/ig, ""); }
};

//Curse.Editor.FileBrowser = {
//    curseFileBrowser: function(field_name, url, type, win) {
//        //alert("Field_Name: " + field_name + "\nURL: " + url + "\nType: " + type + "\nWin: " + win);

//        /* If you work with sessions in PHP and your client doesn't accept cookies you might need to carry
//        the session name and session ID in the request string (can look like this: "?PHPSESSID=88p0n70s9dsknra96qhuk6etm5").
//        These lines of code extract the necessary parameters and add them back to the filebrowser URL again. */

//        var cmsURL = window.location.toString();    // script URL - use an absolute path!
//        if (cmsURL.indexOf("?") < 0) {
//            //add the type as the only query parameter
//            cmsURL = cmsURL + "?type=" + type;
//        }
//        else {
//            //add the type as an additional query parameter
//            // (PHP session ID is now included if there is one at all)
//            cmsURL = cmsURL + "&type=" + type;
//        }

//        tinyMCE.activeEditor.windowManager.open({
//            file: cmsURL,
//            title: 'My File Browser',
//            width: 420,  // Your dimensions may differ - toy around with them!
//            height: 400,
//            resizable: "yes",
//            inline: "yes",  // This parameter only has an effect if you use the inlinepopups plugin!
//            close_previous: "no"
//        }, {
//            window: win,
//            input: field_name
//        });
//        return false;
//    }
//};
