﻿using System;
using System.Configuration;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.IO;
using System.Text.RegularExpressions;
using System.Web;

namespace Curse.PayPal
{

    public enum EPaypalStatusCode
    {
        Success = 1,
        AlreadyCancelled = 2,
        UnableToCancel = 3
    }

    public class SubscriptionManagement
    {
        private static Regex sUrlMatch = new Regex("URL=(?<Url>.*?)$", RegexOptions.Compiled);
        private static Regex sInfoMatch = new Regex("<input type=\"hidden\" name=\"info\" value=\"(?<Info>.*?)\">", RegexOptions.Compiled);
        private static string sPaypalLogin = null;
        private static string sPaypalPassword = null;

        static SubscriptionManagement()
        {
            sPaypalLogin = ConfigurationManager.AppSettings["Curse_PayPalLogin"];
            sPaypalPassword = ConfigurationManager.AppSettings["Curse_PayPalPassword"];
        }

        public static EPaypalStatusCode CancelSubscription(string pSubscriptionId)
        {
            
            CookieContainer cookies = new CookieContainer();

            // Initial Request:
            HttpWebRequest req1 = (HttpWebRequest)WebRequest.Create("https://www.paypal.com/");
            req1.UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)";
            req1.CookieContainer = cookies;
            WebResponse resp = req1.GetResponse();

            // Login Request:
            HttpWebRequest loginRequest = (HttpWebRequest)WebRequest.Create("https://www.paypal.com/us/cgi-bin/webscr?cmd=_login-submit");
            loginRequest.UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)";
            loginRequest.CookieContainer = cookies;
            loginRequest.Referer = "https://www.paypal.com/";
            loginRequest.Method = "POST";
            loginRequest.ContentType = "application/x-www-form-urlencoded";
            string postVals = "login_email=" + HttpUtility.UrlEncode(sPaypalLogin) + "&login_password=" + HttpUtility.UrlEncode(sPaypalPassword) + "&submit.x=Log In&form_charset=UTF-8";
            byte[] postData = System.Text.Encoding.ASCII.GetBytes(postVals);
            loginRequest.ContentLength = postData.Length;
            Stream newStream = loginRequest.GetRequestStream();
            newStream.Write(postData, 0, postData.Length);
            newStream.Close();
            WebResponse loginResponse = loginRequest.GetResponse();
            StreamReader loginResponseStream = new StreamReader(loginResponse.GetResponseStream());
            string loginResponseString = loginResponseStream.ReadToEnd();

            string lastRequestUrl = "https://www.paypal.com/us/cgi-bin/webscr?cmd=_login-submit";
            String nextUrl = loginResponse.Headers["Refresh"];
            Match match = sUrlMatch.Match(nextUrl);
            if (!match.Success)
            {
                return EPaypalStatusCode.UnableToCancel;
            }
            nextUrl = match.Groups["Url"].Value;


            // Login Success Request
            HttpWebRequest loginSuccessRequest = (HttpWebRequest)WebRequest.Create(nextUrl);
            loginSuccessRequest.UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)";
            loginSuccessRequest.CookieContainer = cookies;
            loginSuccessRequest.Referer = lastRequestUrl;
            loginSuccessRequest.Timeout = 3000;
            WebResponse loginSuccessResponse = null;
            for (int i = 0; i < 5; i++)
            {
                System.Threading.Thread.Sleep(500);
                try
                {
                    loginSuccessResponse = loginSuccessRequest.GetResponse();
                    break;
                }
                catch (Exception ex)
                {
                }
            }
            StreamReader loginSuccessResponseStream = new StreamReader(loginSuccessResponse.GetResponseStream());
            string loginSuccessResponseString = loginSuccessResponseStream.ReadToEnd();

            if (loginSuccessRequest == null)
            {
                return EPaypalStatusCode.UnableToCancel;
            }

            string subscriptionInfo = null;
            System.Threading.Thread.Sleep(500);
            EPaypalStatusCode status = getSubscriptionInfo(cookies, pSubscriptionId, out subscriptionInfo);
            if (status != EPaypalStatusCode.Success)
            {
                return status;
            }
            return processCancellation(cookies, subscriptionInfo);
        }

        private static EPaypalStatusCode processCancellation(CookieContainer pCookies, string pSubscriptionInfo)
        {
            HttpWebRequest req = (HttpWebRequest)WebRequest.Create("https://www.paypal.com/row/cgi-bin/webscr?__track=_subscr-details-submit:p/acc/subscribe-cancel-confirm:_subscr-cancel-submit");
            req.UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)";
            req.CookieContainer = pCookies;
            req.Referer = "https://www.paypal.com/row/cgi-bin/webscr?__track=_history-search:p/acc/history-subscribe:_subscr-details-submit";
            req.Method = "POST";
            req.ContentType = "application/x-www-form-urlencoded";

            string postVals = "return_to=&history_cache=&info=" + HttpUtility.UrlEncode(pSubscriptionInfo) + "&sub_info=&email_alias=&cmd=_subscr-cancel-submit&reverse.x=Cancel Subscription";
            byte[] postData = System.Text.Encoding.ASCII.GetBytes(postVals);
            req.ContentLength = postData.Length;

            Stream newStream = req.GetRequestStream();
            newStream.Write(postData, 0, postData.Length);
            newStream.Close();
            WebResponse resp = req.GetResponse();
            StreamReader respStream = new StreamReader(resp.GetResponseStream());
            string respString = respStream.ReadToEnd();
            if (!respString.Contains("This subscription has been cancelled."))
            {
                return EPaypalStatusCode.UnableToCancel;
            }
            return EPaypalStatusCode.Success;
        }

        private static EPaypalStatusCode getSubscriptionInfo(CookieContainer pCookies, string pSubscriptionId, out string pInfo)
        {

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create("https://www.paypal.com/row/cgi-bin/webscr?__track=_history-search:p/acc/history_search:_history-search");
            req.UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)";
            req.CookieContainer = pCookies;
            req.Referer = "https://www.paypal.com/row/cgi-bin/webscr?cmd=_history-search";
            req.Method = "POST";
            req.ContentType = "application/x-www-form-urlencoded";

            string postVals = "return_to=&history_cache=&item=0&search_type=" + HttpUtility.UrlEncode(pSubscriptionId) +
               "&search_first_type=trans_id&span=broad&for=4&from_a=07&from_b=16&from_c=2004&to_a=08&to_b=15&to_c=" +
               DateTime.UtcNow.Year + "&cmd=_history-search&submit.x=Submit";
            byte[] postData = System.Text.Encoding.ASCII.GetBytes(postVals);
            req.ContentLength = postData.Length;

            Stream newStream = req.GetRequestStream();
            newStream.Write(postData, 0, postData.Length);
            newStream.Close();
            WebResponse resp = req.GetResponse();
            StreamReader respStream = new StreamReader(resp.GetResponseStream());
            string respString = respStream.ReadToEnd();

            if (respString.Contains("Date of Cancellation"))
            {
                pInfo = null;
                return EPaypalStatusCode.AlreadyCancelled;
            }
            if (!respString.Contains("Cancel Subscription"))
            {
                pInfo = null;
                return EPaypalStatusCode.UnableToCancel;
            }

            Match infoMatch = sInfoMatch.Match(respString);
            if (!infoMatch.Success)
            {
                pInfo = null;
                return EPaypalStatusCode.UnableToCancel;
            }

            pInfo = infoMatch.Groups["Info"].Value;
            return EPaypalStatusCode.Success;
        }
    }
}
