﻿using System;
using System.Runtime.Serialization;
using System.ServiceModel.Configuration;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;
using System.ServiceModel.Channels;
using System.ServiceModel;

namespace Curse.ServiceModels.Authentication
{
    [DataContract(Namespace = ServiceAuthenticationToken.HeaderNamespace)]
    public sealed class ServiceAuthenticationToken
    {
        public const string HeaderName = "AuthenticationContext";
        public const string HeaderNamespace = "urn:Curse.ServiceModels:v1";

        // These are the fields that will be serialized and passed through the header
        [DataMember]
        public string Username { get; set; }

        [DataMember]
        public string Password { get; set; }

        public bool IsAnonymous
        {
            get;
            set;
        }

        public ServiceAuthenticationToken() { }

        public ServiceAuthenticationToken(string username, string password)
        {
            Username = username;
            Password = password;
        }


        private static ServiceAuthenticationToken _outgoing;

        // These are the values owned by the client's current
        // thread, that will be passed to the service.
        public static ServiceAuthenticationToken Outgoing
        {
            get
            {
                return _outgoing;
            }
            set
            {
                _outgoing = value;
            }
        }
    }
    public sealed class ServiceAuthenticationTokenExtension : BehaviorExtensionElement, IEndpointBehavior, IClientMessageInspector
    {
        public override Type BehaviorType
        {
            get { return GetType(); }
        }

        protected override object CreateBehavior()
        {
            return new ServiceAuthenticationTokenExtension();
        }

        object IClientMessageInspector.BeforeSendRequest(ref Message request, IClientChannel channel)
        {
            MessageHeader messageHeader = MessageHeader.CreateHeader(ServiceAuthenticationToken.HeaderName, ServiceAuthenticationToken.HeaderNamespace, ServiceAuthenticationToken.Outgoing);
            request.Headers.Add(messageHeader);
            return null;

        }

        void IEndpointBehavior.ApplyClientBehavior(ServiceEndpoint endpoint, ClientRuntime clientRuntime)
        {
            clientRuntime.MessageInspectors.Add(new ServiceAuthenticationTokenExtension());
        }

        void IClientMessageInspector.AfterReceiveReply(ref Message reply, object correlationState)
        {
            // Do nothing
        }

        void IEndpointBehavior.AddBindingParameters(ServiceEndpoint endpoint, BindingParameterCollection bindingParameters)
        {
            // Do nothing
        }

        void IEndpointBehavior.ApplyDispatchBehavior(ServiceEndpoint endpoint, EndpointDispatcher endpointDispatcher)
        {
            // Do nothing
        }

        void IEndpointBehavior.Validate(ServiceEndpoint endpoint)
        {
            // Do nothing
        }
    }
}
