﻿using System;
using System.Configuration;
using Curse.ServiceModels.Authentication;

namespace Curse.ServiceModels.Configuration
{
    public class AuthenticationConfigElement : CurseConfigurationElement
    {
        public AuthenticationConfigElement() { }

        [ConfigurationProperty("authenticationType", IsRequired = true)]
        public AuthenticationType AuthenticationType
        {
            get
            {
                return (AuthenticationType)this["authenticationType"];
            }
            internal set
            {
                this["authenticationType"] = value;
            }
        }

        [ConfigurationProperty("serviceAuthentiaction", IsRequired = false)]
        public ServiceAuthenticationElement ServiceAuthentication
        {
            get
            {
                return (ServiceAuthenticationElement)this["serviceAuthentiaction"];
            }
            internal set
            {
                this["serviceAuthentiaction"] = value;
            }
        }

        [ConfigurationProperty("apiAuthentication", IsRequired = false)]
        public ApiAuthenticationElement ApiAuthentication
        {
            get
            {
                return (ApiAuthenticationElement)this["apiAuthentication"];
            }
            internal set
            {
                this["apiAuthentication"] = value;
            }
        }
    }

    public class ServiceAuthenticationElement : ConfigurationElement
    {
        [ConfigurationProperty("freePremium", IsRequired = false, DefaultValue = false)]
        public bool FreePremium
        {
            get { return (bool)this["freePremium"]; }
            internal set { this["freePremium"] = value; }
        }

        [ConfigurationProperty("authSessionLifespan", IsRequired = false, DefaultValue = "00:20:00")]
        public TimeSpan AuthSessionLifespan
        {
            get
            {
                return (TimeSpan)this["authSessionLifespan"];
            }
            internal set
            {
                this["authSessionLifespan"] = value;
            }
        }

        [ConfigurationProperty("authServiceUrl", IsRequired = true)]
        public string AuthServiceUrl
        {
            get
            {
                return (string)this["authServiceUrl"];
            }
            internal set
            {
                this["authServiceUrl"] = value;
            }
        }

        [ConfigurationProperty("authServiceTimeout", IsRequired = false, DefaultValue = "5000")]
        public int AuthServiceTimeout
        {
            get
            {
                return (int)this["authServiceTimeout"];
            }
            internal set
            {
                this["authServiceTimeout"] = value;
            }
        }

        [ConfigurationProperty("authSiteID", IsRequired = true)]
        public int AuthSiteID
        {
            get
            {
                return (int)this["authSiteID"];
            }
            internal set
            {
                this["authSiteID"] = value;
            }
        }

        [ConfigurationProperty("authSiteKey", IsRequired = true)]
        public string AuthSiteKey
        {
            get
            {
                return (string)this["authSiteKey"];
            }
            internal set
            {
                this["authSiteKey"] = value;
            }
        }
    }

    public class ApiAuthenticationElement : ConfigurationElement
    {
        [ConfigurationProperty("perUser", IsRequired = false, DefaultValue = false)]
        public bool PerUser
        {
            get
            {
                return (bool)this["perUser"];
            }
            internal set
            {
                this["perUser"] = value;
            }
        }

        [ConfigurationProperty("perUserDataSource", IsRequired = false, DefaultValue = "")]
        public string PerUserDataSource
        {
            get
            {
                return (string)this["perUserDataSource"];
            }
            internal set
            {
                this["perUserDataSource"] = value;
            }
        }

        [ConfigurationProperty("perUserCatalog", IsRequired = false, DefaultValue = "")]
        public string PerUserCatalog
        {
            get
            {
                return (string)this["perUserCatalog"];
            }
            internal set
            {
                this["perUserCatalog"] = value;
            }
        }
        
        [ConfigurationProperty("apiKey", IsRequired = false, DefaultValue = "")]
        public string ApiKey
        {
            get
            {
                return (string)this["apiKey"];
            }
            internal set
            {
                this["apiKey"] = value;
            }
        }
    }
}
