﻿using System;
using System.Configuration;

namespace Curse.ServiceModels.Configuration
{
    public class CurseConfigurationElementCollection<T> : ConfigurationElementCollection where T : CurseConfigurationElement
    {
        private T _active;
        public T Active
        {
            get
            {
                if (_active == null)
                {
                    foreach (T key in this)
                    {
                        if (key.Key == ServiceConfiguration.ActiveConfigurationName)
                        {
                            _active = key;
                            break;
                        }
                    }
                }
                return _active;
            }
        }
        public ServiceConfiguration this[int index]
        {
            get
            {
                return base.BaseGet(index) as ServiceConfiguration;
            }
            set
            {
                if (base.BaseGet(index) != null)
                {
                    base.BaseRemoveAt(index);
                }
                this.BaseAdd(index, value);
            }
        }

        protected override ConfigurationElement CreateNewElement()
        {
            return Activator.CreateInstance(typeof(T)) as T;
        }
        protected override object GetElementKey(ConfigurationElement element)
        {
            return ((T)element).Key;
        }
    }
}
