﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;

namespace Curse.ServiceModels.Configuration
{
    public class DatabaseConnectionElement : CurseConfigurationElement
    {
        [ConfigurationProperty("database", IsRequired = true)]
        [ConfigurationCollection(typeof(DatabaseProviderElement), AddItemName = "databaseProvider")]
        CurseConfigurationElementCollection<DatabaseProviderElement> _Database
        {
            get { return (CurseConfigurationElementCollection<DatabaseProviderElement>)this["database"]; }
            set { this["database"] = value; }
        }

        public DatabaseProviderElement Database
        {
            get { return _Database.Active; }
        }
    }
}
