﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WGOBDocument
        : WDBDocument
    {
        public List<WGOBObject> Objects = new List<WGOBObject>();

        public WGOBDocument(WDBReader pReader)
            : base(pReader)
        {
        }

        public override void Read(WDBReader pReader)
        {
            if (!Supported)
            {
                throw new WDBException("Unsupported version for game object cache");
            }

            WGOBObject obj = null;
            while (pReader.Length > 8)
            {
                obj = new WGOBObject();
                obj.Read(pReader);
                Objects.Add(obj);
            }
        }
    }
}
