﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WGOBObject
        : IPackable
    {
        public Int32 Id = 0;
        public Int32 Type = 0;
        public Int32 DisplayInfo = 0;
        public Int32 LockId = 0;
        public String Name = "";

        public void Read(WDBReader pReader)
        {
            Id = pReader.ReadInt32();
            Int32 length = pReader.ReadInt32();
            Int64 begin = pReader.Length;

            Type = pReader.ReadInt32();
            DisplayInfo = pReader.ReadInt32();
            Name = pReader.ReadString();
            pReader.SkipNext('\0', 6);
            LockId = pReader.ReadInt32();            
            pReader.Skip(23 * 4);
            if (pReader.Version >= (Int32)WDBVersions.WowVersion_2_4_3)
            {
                pReader.Skip(4);
            }
            if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_1_0)
            {
                pReader.Skip(16);
            }

            if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_3_0)
            {
                pReader.Skip(8);
            }

            Debug.Assert(begin - pReader.Length == length);
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Id) &&
                   pBuf.Write(Type) &&
                   pBuf.Write(DisplayInfo) &&
                   pBuf.Write(LockId) &&
                   pBuf.Write(Name);
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Id) &&
                   pBuf.Read(ref Type) &&
                   pBuf.Read(ref DisplayInfo) &&
                   pBuf.Read(ref LockId) &&
                   pBuf.Read(ref Name);
        }
    }
}
