﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WMOBDocument
        : WDBDocument
    {
        public List<WMOBCreature> Creatures = new List<WMOBCreature>();

        public WMOBDocument(WDBReader pReader)
            : base(pReader)
        {
        }

        public override void Read(WDBReader pReader)
        {
            if (!Supported)
            {
                throw new WDBException("Unsupported version for creature cache");
            }

            WMOBCreature creature = null;
            while (pReader.Length > 8)
            {
                creature = new WMOBCreature();
                creature.Read(pReader);
                Creatures.Add(creature);
            }
        }
    }
}
