﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WPTXPage
        : IPackable
    {
        public Int32 Id = 0;
        public String Text = "";
        public Int32 NextPage = 0;

        public void Read(WDBReader pReader)
        {
            Id = pReader.ReadInt32();
            Int32 length = pReader.ReadInt32();
            Int64 begin = pReader.Length;

            Text = pReader.ReadString();
            NextPage = pReader.ReadInt32();

            Debug.Assert(begin - pReader.Length == length);
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Id) &&
                   pBuf.Write(Text) &&
                   pBuf.Write(NextPage);
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Id) &&
                   pBuf.Read(ref Text) &&
                   pBuf.Read(ref NextPage);
        }
    }
}
