﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WQSTDocument
        : WDBDocument
    {
        public List<WQSTQuest> Quests = new List<WQSTQuest>();

        public WQSTDocument(WDBReader pReader)
            : base(pReader)
        {
        }

        public override void Read(WDBReader pReader)
        {
            if (!Supported)
            {
                throw new WDBException("Unsupported version for quest cache");
            }

            WQSTQuest quest = null;
            while (pReader.Length > 8)
            {
                quest = new WQSTQuest();
                quest.Read(pReader);
                Quests.Add(quest);
            }
        }
    }
}
