﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WQSTTask
        : IPackable
    {
        public Int32 KillCreature = 0;
        public Int32 KillCount = 0;
        public Int32 CollectItem = 0;
        public Int32 CollectCount = 0;
        public Int32 Unknown = 0;
        public void Read(WDBReader pReader)
        {
            KillCreature = pReader.ReadInt32();
            KillCount = pReader.ReadInt32();
            CollectItem = pReader.ReadInt32();
            CollectCount = pReader.ReadInt32();
            if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_0_1)
            {
                Unknown = pReader.ReadInt32();
            }
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(KillCreature) &&
                   pBuf.Write(KillCount) &&
                   pBuf.Write(CollectItem) &&
                   pBuf.Write(CollectCount) &&
                   pBuf.Write(Unknown);
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref KillCreature) &&
                   pBuf.Read(ref KillCount) &&
                   pBuf.Read(ref CollectItem) &&
                   pBuf.Read(ref CollectCount) &&
                   pBuf.Read(ref Unknown);
        }
    }
}
