﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW
{
    public sealed class LootableGameObject
        : IPackable
    {
        public Int32 MethodId = 0;
        public Byte Area = 0;
        public Int16 X = 0;
        public Int16 Y = 0;
        public PackableList<Loot> Loots = new PackableList<Loot>();
        public String Requirement = null;
        public String Name = null;
        

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref MethodId) &&
                   pBuf.Read(ref Area) &&
                   pBuf.Read(ref X) &&
                   pBuf.Read(ref Y) &&
                   Loots.Read(pBuf) &&
                   pBuf.Read(ref Requirement) &&
                   pBuf.Read(ref Name);
        }
    }
}
