﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW
{
    public sealed class PlayerSpellStatistics
        : IPackable
    {
        public Int16 HolyBonus = 0;
        public Int16 FireBonus = 0;
        public Int16 NatureBonus = 0;
        public Int16 FrostBonus = 0;
        public Int16 ShadowBonus = 0;
        public Int16 ArcaneBonus = 0;
        public Int16 HealingBonus = 0;
        public Int16 HolyCritical = 0;
        public Int16 FireCritical = 0;
        public Int16 NatureCritical = 0;
        public Int16 FrostCritical = 0;
        public Int16 ShadowCritical = 0;
        public Int16 ArcaneCritical = 0;
        public Int16 Penetration = 0;
        public Int16 MP5NotCasting = 0;
        public Int16 MP5Casting = 0;

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref HolyBonus) &&
                   pBuf.Read(ref FireBonus) &&
                   pBuf.Read(ref NatureBonus) &&
                   pBuf.Read(ref FrostBonus) &&
                   pBuf.Read(ref ShadowBonus) &&
                   pBuf.Read(ref ArcaneBonus) &&
                   pBuf.Read(ref HealingBonus) &&
                   pBuf.Read(ref HolyCritical) &&
                   pBuf.Read(ref FireCritical) &&
                   pBuf.Read(ref NatureCritical) &&
                   pBuf.Read(ref FrostCritical) &&
                   pBuf.Read(ref ShadowCritical) &&
                   pBuf.Read(ref ArcaneCritical) &&
                   pBuf.Read(ref Penetration) &&
                   pBuf.Read(ref MP5NotCasting) &&
                   pBuf.Read(ref MP5Casting);
        }
    }
}
