﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW
{
    public sealed class Quest
        : IPackable
    {
        public Int32 Id = 0;
        public Byte LowestLevel = 0;
        public PackableByteList Classes = new PackableByteList();
        public PackableByteList Races = new PackableByteList();
        public Byte StartingIdType = 0;
        public Int32 StartingId = 0;
        public Byte FinishingIdType = 0;
        public Int32 FinishingId = 0;
        public Int16 TimeToComplete = 0;
        public Int32 ExperienceGained = 0;
        public PackableList<FactionChange> FactionChanges = new PackableList<FactionChange>();
        public String MidText = null;
        public String EndText = null;

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Id) &&
                   pBuf.Read(ref LowestLevel) &&
                   Classes.Read(pBuf) &&
                   Races.Read(pBuf) &&
                   pBuf.Read(ref StartingIdType) &&
                   pBuf.Read(ref StartingId) &&
                   pBuf.Read(ref FinishingIdType) &&
                   pBuf.Read(ref FinishingId) &&
                   pBuf.Read(ref TimeToComplete) &&
                   pBuf.Read(ref ExperienceGained) &&
                   FactionChanges.Read(pBuf) &&
                   pBuf.Read(ref MidText) &&
                   pBuf.Read(ref EndText);
        }
    }
}
