﻿using Curse;
using Curse.WoW.WDB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW
{
    public sealed class Update
        : IPackable
    {
        // Private Variables
        private Int64 mMinProfilerversion = 0;
        public StatusCode UpdateStatus = StatusCode.Ok;
        public Int64 ProfilerVersion = 0;
        public String Realmlist = null;
        public String Locale = null;
        public String ClientVersion = null;
        public Int16 ClientBuild = 0;

        public PackableStringList Errors = new PackableStringList();
        public PackableStringList Areas = new PackableStringList();
        public PackableStringList Factions = new PackableStringList();
        public PackableList<QuestGameObject> QuestGameObjects = new PackableList<QuestGameObject>();
        public PackableList<LootableItem> LootableItems = new PackableList<LootableItem>();
        public PackableList<LootableGameObject> LootableGameObjects = new PackableList<LootableGameObject>();
        public PackableList<NPC> NPCs = new PackableList<NPC>();
        public PackableList<Player> Players = new PackableList<Player>();
        public PackableList<Quest> Quests = new PackableList<Quest>();

        public UInt16 CacheVersion = 0;
        public PackableList<WMOBCreature> CreatureCache = new PackableList<WMOBCreature>();
        public PackableList<WGOBObject> GameObjectCache = new PackableList<WGOBObject>();
        public PackableList<WIDBItem> ItemCache = new PackableList<WIDBItem>();

        public PackableList<WPTXPage> PageTextCache = new PackableList<WPTXPage>();
        public PackableList<WQSTQuest> QuestCache = new PackableList<WQSTQuest>();

        public Update(Int64 pMinProfilerVersion)
        {
            mMinProfilerversion = pMinProfilerVersion;            
        }

        public void AddCreatureCache(String pWDBPath,
                                     String pLogPath)
        {
            String logfile = pLogPath + "wow_creature.log";
            ObjectLogFile log = new ObjectLogFile(logfile);
            WMOBDocument doc = null;
            using (WDBReader reader = new WDBReader(pWDBPath))
            {
                doc = new WMOBDocument(reader);
                doc.Read(reader);
                foreach (WMOBCreature creature in doc.Creatures)
                {
                    if (log.AddObject(creature.Id))
                    {
                        CreatureCache.Add(creature);
                    }
                }
            }
            if (CacheVersion == 0)
            {
                CacheVersion = Convert.ToUInt16(doc.Version);
            }
            else if (CacheVersion != doc.Version)
            {
                throw new Exception("Creature cache version incorrect");
            }
        }

        public void AddGameObjectCache(String pWDBPath,
                                       String pLogPath)
        {
            String logfile = pLogPath + "wow_object.log";
            ObjectLogFile log = new ObjectLogFile(logfile);
            WGOBDocument doc = null;
            using (WDBReader reader = new WDBReader(pWDBPath))
            {
                doc = new WGOBDocument(reader);
                doc.Read(reader);
                foreach (WGOBObject obj in doc.Objects)
                {
                    if (log.AddObject(obj.Id))
                    {
                        GameObjectCache.Add(obj);
                    }
                }
            }
            if (CacheVersion == 0)
            {
                CacheVersion = Convert.ToUInt16(doc.Version);
            }
            else if (CacheVersion != doc.Version)
            {
                throw new Exception("Object cache version incorrect");
            }
        }

        public void AddItemCache(String pWDBPath,
                                 String pLogPath)
        {
            String logfile = pLogPath + "wow_item.log";
            ObjectLogFile log = new ObjectLogFile(logfile);
            WIDBDocument doc = null;
            using (WDBReader reader = new WDBReader(pWDBPath))
            {
                doc = new WIDBDocument(reader);
                doc.Read(reader);
                foreach (WIDBItem item in doc.Items)
                {
                    if (log.AddObject(item.Id))
                    {
                        ItemCache.Add(item);
                    }
                }
            }
            if (CacheVersion == 0)
            {
                CacheVersion = Convert.ToUInt16(doc.Version);
            }
            else if (CacheVersion != doc.Version)
            {
                throw new Exception("Item cache version incorrect");
            }
        }

        public void AddPageTextCache(String pWDBPath,
                                     String pLogPath)
        {
            String logfile = pLogPath + "wow_page.log";
            ObjectLogFile log = new ObjectLogFile(logfile);
            WPTXDocument doc = null;
            using (WDBReader reader = new WDBReader(pWDBPath))
            {
                doc = new WPTXDocument(reader);
                doc.Read(reader);
                foreach (WPTXPage page in doc.Pages)
                {
                    if (log.AddObject(page.Id))
                    {
                        PageTextCache.Add(page);
                    }
                }
            }
            if (CacheVersion == 0)
            {
                CacheVersion = Convert.ToUInt16(doc.Version);
            }
            else if (CacheVersion != doc.Version)
            {
                throw new Exception("Page text cache version incorrect");
            }
        }

        public void AddQuestCache(String pWDBPath,
                                  String pLogPath)
        {
            String logfile = pLogPath + "wow_quest.log";
            ObjectLogFile log = new ObjectLogFile(logfile);
            WQSTDocument doc = null;
            using (WDBReader reader = new WDBReader(pWDBPath))
            {
                doc = new WQSTDocument(reader);
                doc.Read(reader);
                foreach (WQSTQuest quest in doc.Quests)
                {
                    if (log.AddObject(quest.Id))
                    {
                        QuestCache.Add(quest);
                    }
                }
            }
            if (CacheVersion == 0)
            {
                CacheVersion = Convert.ToUInt16(doc.Version);
            }
            else if (CacheVersion != doc.Version)
            {
                throw new Exception("Quest cache version incorrect");
            }
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(CacheVersion) &&
                   CreatureCache.Write(pBuf) &&
                   GameObjectCache.Write(pBuf) &&
                   ItemCache.Write(pBuf) &&
                   PageTextCache.Write(pBuf) &&
                   QuestCache.Write(pBuf);
        }

        public Boolean Read(IReadable pBuf)
        {
            UInt32 profilerDataLength = 0;
            Boolean ok = pBuf.Read(ref profilerDataLength) &&
                         pBuf.Read(ref ProfilerVersion) &&
                         pBuf.Read(ref Realmlist) &&
                         pBuf.Read(ref Locale) &&
                         pBuf.Read(ref ClientVersion) &&
                         pBuf.Read(ref ClientBuild) &&
                         Errors.Read(pBuf);
            if (!ok)
            {
                UpdateStatus = StatusCode.InvalidStream;
                return false;
            }

            if (ProfilerVersion < mMinProfilerversion)
            {
                UpdateStatus = StatusCode.InvalidProfilerVersion;
                return false;
            }

            if (Errors.Count > 0)
            {
                Logger.Log(ELogLevel.Error, null, "LUA Errors: {0}", String.Join(Environment.NewLine, Errors.ToArray()));
                return false;
            }
           
            if (!Areas.Read(pBuf))
            {
                return false;
            }            
            if (!Factions.Read(pBuf))
            {
                return false;
            }
            if (!QuestGameObjects.Read(pBuf))
            {
                return false;
            }
            if (!LootableItems.Read(pBuf) )
            {
                return false;
            }
            if (!LootableGameObjects.Read(pBuf))
            {
                return false;
            }
            if (!NPCs.Read(pBuf) )
            {
                return false;
            }
            if (!Players.Read(pBuf))
            {
                return false;
            }
            if (!Quests.Read(pBuf))
            {
                return false;
            }
            if (!pBuf.Read(ref CacheVersion))
            {
                return false;
            }
            if (!CreatureCache.Read(pBuf))
            {
                return false;
            }
            if (!GameObjectCache.Read(pBuf))
            {
                return false;
            }
            if (!ItemCache.Read(pBuf))
            {
                return false;
            }
            if (!PageTextCache.Read(pBuf) )
            {
                return false;
            }
           if (!QuestCache.Read(pBuf))
           {
               return false;
           }
           return true;
        }
    }
}
