﻿using System;
using System.Collections.Generic;
using System.Security.Cryptography;
using System.Text;

namespace Curse
{
    /**
     * Handles complex key hashing in a proven fast and generic way
     * Joins the ToString values and generates a 32bit hash for it
     *
     * @author Michael Comperda
     */
    public sealed class CustomKey
    {
        /**
         * Handles custom equality comparison of hashes for various collections
         *
         * @author Michael Comperda
         */
        public sealed class CustomKeyComparer
            : IEqualityComparer<CustomKey>
        {
            public Boolean Equals(CustomKey pX,
                                  CustomKey pY)
            {
                return pX.mHashCode == pY.mHashCode;
            }

            public Int32 GetHashCode(CustomKey pObj)
            {
                return pObj.mHashCode;
            }
        }

        /**
         * Initialization constructor
         * Joins all the object ToString values with a pipe delimiter
         * Calculates and stores the resulting hash
         */
        public CustomKey(params Object[] pArgs)
        {
            mHashCode = CalculateHash(String.Join("|",
                                                  Array.ConvertAll<Object, String>(pArgs, o => o.ToString())));
        }

        /**
         * Support method to quickly and easily generate a 32bit hash
         * 
         * @param  pHash  the string to hash
         * @return        the resulting hash
         */
        private Int32 CalculateHash(String pHash)
        {

            return pHash.GetHashCode();
        }

        /**
         * Member variables
         */
        private Int32 mHashCode = 0;
    }
}
