﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Globalization;

namespace Curse
{
    public class DateTimeHelper
    {
        public class Month
        {
            public Month(int value, string label)
            {
                Label = label;
                Value = value;
            }

            public string Label
            {
                get;
                set;
            }
            public int Value
            {
                get;
                set;
            }
        }

        public static List<Month> GetMonths()
        {
            return GetMonths(System.Globalization.DateTimeFormatInfo.CurrentInfo);            
        }

        public static List<Month> GetMonths(DateTimeFormatInfo dateTimeFormatInfo)
        {
            List<Month> months = new List<Month>();
            for (int i = 0; i < 12; i++)
            {
                months.Add(new Month(i + 1, dateTimeFormatInfo.MonthNames[i]));
            }
            return months;
        }
    }
}
