﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography;

namespace Curse.Extensions
{
    public static class ByteExtensions
    {
        public static string ToHexString(this byte[] value)
        {
            Int32 length = value.Length;
            String hexString = String.Empty;
            for (Int32 i = 0; i < length; i++)
            {
                hexString += value[i].ToString("X").PadLeft(2, '0');
            }

            return hexString;
        }

        public static string ComputeHash(this byte[] value)
        {
            SHA1Managed sha1 = new SHA1Managed();
            Byte[] hash = sha1.ComputeHash(value);
            return BitConverter.ToString(hash).Replace("-", "").ToLower();
        }
      
    }
}
