﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace Curse.Extensions
{
    public static class DirectoryInfoExtensions
    {
        public static FileInfo[] GetMatchingFiles(this DirectoryInfo directory, string searchPatterns, SearchOption searchOption)
        {
            string[] searchPatternArray = searchPatterns.Split(';');
            List<FileInfo> matches = new List<FileInfo>();
            foreach (string searchPattern in searchPatternArray)
            {
                matches.AddRange(directory.GetFiles(searchPattern, searchOption));
            }
            return matches.ToArray();
        }
    }
}
