﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace Curse.Extensions
{
    public static class FileInfoExtensions
    {
        public static string GetRelativePath(this FileInfo fileInfo, DirectoryInfo baseDirectory)
        {
            string relativePath = fileInfo.FullName.Replace(baseDirectory.FullName, string.Empty);
            if (relativePath.StartsWith(Path.DirectorySeparatorChar.ToString()))
            {
                relativePath = relativePath.Substring(1);
            }
            return relativePath;
        }        
    }
}
