﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Globalization;
using System.Net.Mail;

namespace Curse.Extensions
{
    public static class StringExtensions
    {
        public static string FormatWith(this string target, params object[] args)
        {
            return string.Format(target, args);
        }

        public static double ParseDouble(this string value)
        {
            return ParseDouble(value, CultureInfo.CurrentCulture);
        }

        private const Int32 HEX_BASE = 16;

        public static byte[] ToByteArray(this string value)
        {
            Int32 length = value.Length;
            Byte[] data = new Byte[(length + 1) / 2];
            for (Int32 index = 0; index < length; index += 2)
            {
                data[index / 2] = Convert.ToByte(value.Substring(index, 2), HEX_BASE);
            }
            return data;        
        }

        public static double ParseDouble(this string value, CultureInfo culture)
        {
            string newValue = string.Empty;
            foreach (char c in value)
            {
                if (char.IsNumber(c) || c == '.' || c == ',')
                {
                    newValue += c;
                }
            }
            if (newValue.Length > 0)
            {
                return double.Parse(newValue, culture);
            }
            else
            {
                return 0;
            }
        }

        public static string Nullify(this string value)
        {
            if (string.IsNullOrEmpty(value))
            {
                return null;
            }
            else
            {
                return value;
            }
        }

        public static bool IsNullOrEmpty(this string value)
        {
            return string.IsNullOrEmpty(value);
        }
        
    }
}
