﻿using System;
using System.Collections.Generic;

namespace Curse.Extensions
{
    public static class UriExtensions
    {
        public static string GetDomainName(this Uri uri)
        {
            if (uri == null)
            {
                throw new ArgumentNullException("uri");
            }

            var host = uri.Host;

            var splits = host.Split('.');

            if (splits.Length < 2)
            {
                return null;
            }

            return splits[splits.Length - 2] + "." + splits[splits.Length - 1];

        }

        public static string[] GetDomainNames(this Uri uri, string[] tlds)
        {
            if (uri == null)
            {
                throw new ArgumentNullException("uri");
            }

            var host = uri.Host;
           
            var splits = host.Split('.');

            if (splits.Length < 2)
            {
                return null;
            }

            var validDomainNames = new List<string>();

            validDomainNames.Add(splits[splits.Length - 2] + "." + splits[splits.Length - 1]);

            foreach (var tld in tlds)
            {
                validDomainNames.Add(splits[splits.Length - 2] + "." + tld);
            }

            return validDomainNames.ToArray();

        }
    }
}
