﻿using System;

namespace Curse
{
    /**
     * Read interface for design flexibility of streamable data buffers
     *
     * @author Michael Comperda
     */
    public interface IReadable
    {
        Boolean Read(Byte[] pBuf,
                     Int32 pIndex,
                     Int32 pLength);
        Boolean Read(ref Boolean pValue);
        Boolean Read(ref Byte pValue);
        Boolean Read(ref SByte pValue);
        Boolean Read(ref Int16 pValue);
        Boolean Read(ref UInt16 pValue);
        Boolean Read(ref Int32 pValue);
        Boolean Read(ref UInt32 pValue);
        Boolean Read(ref Single pValue);
        Boolean Read(ref Int64 pValue);
        Boolean Read(ref UInt64 pValue);
        Boolean Read(ref Double pValue);
        Boolean Read(ref String pValue);
    }
}
