﻿using System;
using System.IO;
using System.Security.Cryptography;

namespace Curse
{
    public static class RijndaelEncryption
    {

        public static byte[] Encrypt(byte[] pEncryptionKey, byte[] pData)
        {

            RijndaelManaged symmetricKey = new RijndaelManaged();
            symmetricKey.Mode = CipherMode.CBC;
            
            // Generate the IV
            RNGCryptoServiceProvider rng = new RNGCryptoServiceProvider();
            byte[] iv = new byte[16];
            rng.GetBytes(iv);

            ICryptoTransform encryptor = symmetricKey.CreateEncryptor(pEncryptionKey, iv);
            byte[] encryptedBytes = null;

            using (MemoryStream memoryStream = new MemoryStream())
            {

                using (CryptoStream cryptoStream = new CryptoStream(memoryStream,
                                                        encryptor,
                                                        CryptoStreamMode.Write))
                {
                
                    cryptoStream.Write(pData, 0, pData.Length);
                    cryptoStream.FlushFinalBlock();
                    encryptedBytes = memoryStream.ToArray();
            
                }
            }

            Byte[] encryptedResponse = new Byte[iv.Length + encryptedBytes.Length];
            Buffer.BlockCopy(iv, 0, encryptedResponse, 0, iv.Length);
            Buffer.BlockCopy(encryptedBytes, 0, encryptedResponse, iv.Length, encryptedBytes.Length);

            return encryptedResponse;
        }
    }
}
