﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using Curse.GameServers.Geocoding;
using Curse.GameServers.Configuration;

namespace Curse.GameServers.Caching
{
    public class CountryCache
    {
        private Dictionary<int, string> _countries;
        private object _countryLock = new object();
        
        private List<CountryIPRange> _countryIpRanges;
        private object _countryIpRangeLock = new object();

        static CountryCache _instance = new CountryCache();
        public static CountryCache Instance { get { return _instance; } }

        public CountryCache()
        {
            _countryIpRanges = new List<CountryIPRange>();
            PopulateGeoData();

            _countries = new Dictionary<int, string>();
        }
        public void Initialize() { }

        public void PopulateGeoData()
        {
            List<CountryIPRange> countryIPRanges = new List<CountryIPRange>();
            using (var conn = DatabaseConfiguration.GetGameServerConnection())
            {
                var cmd = new SqlCommand("SELECT * FROM CountryIpRange ORDER BY CountryCode", conn);
                using (var reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        countryIPRanges.Add(new CountryIPRange(reader));
                    }
                }
                CountryIPRange.BuildRanges(countryIPRanges);
            }

            lock (_countryIpRangeLock)
            {
                _countryIpRanges = countryIPRanges;
            }
        }
        
        public int GetCountryIdFromCode(string countryCode)
        {
            var countryId = 0;
            if (!_countries.ContainsValue(countryCode))
            {
                countryId = GetFromDatabaseByCode(countryCode);
                if (countryId != 0)
                {
                    lock (_countryLock)
                    {
                        _countries.Add(countryId, countryCode);
                    }

                    return countryId;
                }
            }
            
            return _countries.FirstOrDefault(p => p.Value == countryCode).Key;
        }
        public int GetFromDatabaseByCode(string countryCode)
        {
            using (var conn = DatabaseConfiguration.GetGameServerConnection())
            {
                var cmd = new SqlCommand("SELECT ID FROM Country WHERE Code = @Code", conn);
                cmd.Parameters.Add("Code", System.Data.SqlDbType.VarChar).Value = countryCode;

                using (var reader = cmd.ExecuteReader())
                {
                    if (reader.Read())
                    {
                        return reader.GetInt32(0);
                    }

                    return 0;
                }
            }
        }
        public string GetCountryCodeFromId(int countryId)
        {
            var countryCode = string.Empty;
            if (!_countries.ContainsKey(countryId))
            {
                countryCode = GetFromDatabaseById(countryId);
                if (!string.IsNullOrEmpty(countryCode))
                {
                    lock (_countryLock)
                    {
                        _countries.Add(countryId, countryCode);
                    }
                }

                return countryCode;
            }

            return _countries[countryId];
        }
        public string GetFromDatabaseById(int countryId)
        {
            using (var conn = DatabaseConfiguration.GetGameServerConnection())
            {
                var cmd = new SqlCommand("SELECT Code FROM Country WHERE ID = @ID", conn);
                cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = countryId;

                using (var reader = cmd.ExecuteReader())
                {
                    if (reader.Read())
                    {
                        return reader.GetString(0);
                    }

                    return null;
                }
            }
        }
    }
}