﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.GameServers.Configuration;
using Curse.GameServers.Extensions;
using System.Data.SqlClient;

namespace Curse.GameServers.Caching
{
    public class GamePlayerCache
    {
        private List<CGamePlayer> _gamePlayers;
        private object _gamePlayerLock = new object();

        private List<CGameServerPlayer> _gameServerPlayers;
        private object _gameServerPlayerLock = new object();

        private static readonly GamePlayerCache _instance = new GamePlayerCache();
        public static GamePlayerCache Instance { get { return _instance; } }

        private GamePlayerCache()
        {
            _gamePlayers = new List<CGamePlayer>();
            _gameServerPlayers = new List<CGameServerPlayer>();
        }

        public Dictionary<int, List<CGameServerPlayer>> GetGameServerPlayerCache(SqlConnection conn, DateTime changeDate)
        {
            var gamePlayers = new List<CGamePlayer>(_gamePlayers);
            var gameServerPlayers = new List<CGameServerPlayer>(_gameServerPlayers);

            var query = "SELECT GameServerPlayer.ID, " +
                "GameServerPlayer.GameServerID,  " +
                "GameServerPlayer.GamePlayerID,  " +
                "GameServerPlayer.DateCreated, " +
                "GameServerPlayer.DateModified,  " +
                "GameServerPlayer.Score,  " +
                "GameServerPlayer.Deaths,  " +
                "GameServerPlayer.TeamName,  " +
                "GamePlayer.Name,  " +
                "GamePlayer.Slug  " +
                "FROM GameServerPlayer WITH(NOLOCK)  " +
                "INNER JOIN GamePlayer WITH(NOLOCK) ON GamePlayer.ID = GameServerPlayer.GamePlayerID  " +
                "INNER JOIN GameServerDataSource ON GameServerDataSource.ID = GamePlayer.GameServerDataSourceID " +
                "INNER JOIN GameServerProcessor ON GameServerProcessor.ID = GameServerDataSource.GameServerProcessorID " +
                "WHERE GameServerProcessor.[Enabled] = 1 " +
                "AND GameServerPlayer.DateModified > @lastModified";

            var cmd = new SqlCommand(query, conn);
            cmd.Parameters.Add("lastModified", System.Data.SqlDbType.DateTime).Value = changeDate;

            using (var reader = cmd.ExecuteReader())
            {
                while (reader.Read())
                {
                    var gamePlayer = new CGamePlayer();
                    gamePlayer.SetFromDataReader(reader);

                    var exitsingPlayer = gamePlayers.FirstOrDefault(p => p.ID == gamePlayer.ID);
                    if (exitsingPlayer != null)
                    {
                        gamePlayers.Remove(exitsingPlayer);
                    }
                    gamePlayers.Add(gamePlayer);

                    var gameServerPlayer = new CGameServerPlayer();
                    gameServerPlayer.SetFromDataReader(reader);
                    gameServerPlayer.GamePlayer = gamePlayers.FirstOrDefault(p => p.ID == gameServerPlayer.GamePlayerID);

                    var existingServerPlayer = gameServerPlayers.FirstOrDefault(p => p.ID == gameServerPlayer.ID);
                    if (existingServerPlayer != null)
                    {
                        gameServerPlayers.Remove(existingServerPlayer);
                    }
                    gameServerPlayers.Add(gameServerPlayer);
                }

                lock (_gamePlayerLock)
                {
                    _gamePlayers = gamePlayers;
                }

                lock (_gameServerPlayerLock)
                {
                    _gameServerPlayers = gameServerPlayers;
                }

                var gamePlayersByServerId = new Dictionary<int, List<CGameServerPlayer>>();
                foreach (int gameServerId in gameServerPlayers.Select(p => p.GameServerID).Distinct())
                {
                    gamePlayersByServerId.Add(gameServerId, gameServerPlayers.Where(p => p.GameServerID == gameServerId).ToList());
                }

                return gamePlayersByServerId;
            }
        }
    }
}