﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;
using Curse.Extensions;
using System.Data.SqlClient;
using Curse.GameServers.Extensions;
using System.Web.Caching;
using Curse.GameServers.Configuration;

namespace Curse.GameServers.Caching
{
    public class GameServerPluginCache
    {
        private string _cacheKey = "GameServerPluginByDataSourceID = {0}";

        static GameServerPluginCache _instance = new GameServerPluginCache();
        public static GameServerPluginCache Instance { get { return _instance; } }

        public GameServerPluginCache() { }
        public void Initialize() { }

        #region Caching
        public List<CGameServerPlugin> GetAllDataSourcePlugins(int dataSourceId)
        {
            return HttpRuntime.Cache.Get(_cacheKey.FormatWith(dataSourceId), () =>
            {
                return GetFromDatabaseByID(dataSourceId);
            });
        }
        private List<CGameServerPlugin> GetFromDatabaseByID(int dataSourceId)
        {
            List<CGameServerPlugin> plugins = new List<CGameServerPlugin>();
            try
            {
                using (var conn = DatabaseConfiguration.GetGameServerConnection())
                {
                    var cmd = new SqlCommand("SELECT * FROM GameServerPlugin WHERE GameServerDataSourceID = @ID", conn);
                    cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = dataSourceId;

                    using (var reader = cmd.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            var plugin = new CGameServerPlugin();
                            plugin.SetFromDataReader(reader);

                            plugins.Add(plugin);
                        }
                    }
                }

                HttpRuntime.Cache.Insert(_cacheKey.FormatWith(dataSourceId), plugins, null, DateTime.Now.AddHours(1), Cache.NoSlidingExpiration);
                return plugins;
            }
            catch (Exception exc)
            {
                Logger.Log("Failed to get GameServerPlugins for data source Id {0} from the database. Details: {1}", ELogLevel.Error, dataSourceId, exc.GetExceptionDetails());
                return null;
            }
        }
        #endregion
    }
}