﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.Extensions;
using System.Configuration;
using System.Data.SqlClient;
using Curse.GameServers.Extensions;
using System.Web.Caching;
using Curse.GameServers.Configuration;

namespace Curse.GameServers.Caching
{
    public class GameServerProcessorCache
    {
        private string _cacheKey = "GameServerProcessorByID = {0}";

        static GameServerProcessorCache _instance = new GameServerProcessorCache();
        public static GameServerProcessorCache Instance { get { return _instance; } }

        public GameServerProcessorCache() { }
        public void Initialize() { }

        #region Caching
        public CGameServerProcessor GetGameProcessorByID(int processorId)
        {
            return HttpRuntime.Cache.Get(_cacheKey.FormatWith(processorId), () =>
            {
                return GetFromDatabaseByID(processorId);
            });
        }
        private CGameServerProcessor GetFromDatabaseByID(int processorId)
        {
            try
            {
                using (var conn = DatabaseConfiguration.GetGameServerConnection())
                {
                    var cmd = new SqlCommand("SELECT * FROM GameServerProcessor WHERE ID = @ID", conn);
                    cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = processorId;

                    using (var reader = cmd.ExecuteReader())
                    {
                        if (reader.Read())
                        {
                            var gameServerProcessor = new CGameServerProcessor();
                            gameServerProcessor.SetFromDataReader(reader);

                            HttpRuntime.Cache.Insert(_cacheKey.FormatWith(processorId), gameServerProcessor, null, DateTime.Now.AddHours(1), Cache.NoSlidingExpiration);
                            return gameServerProcessor;
                        }
                        else
                        {
                            return null;
                        }
                    }
                }
            }
            catch (Exception exc)
            {
                Logger.Log("Failed to get GameServerProcessor with Id {0} from the database. Details: {1}", ELogLevel.Error, processorId, exc.GetExceptionDetails());
                return null;
            }
        }
        #endregion
    }
}