﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using Curse.GameServers.Extensions;

namespace Curse.GameServers.Caching
{
    public class GameServerPropertyCache
    {
        private List<CGameServerProperty> _gameServerProperties;
        private object _gameServerPropertiesLock = new object();

        private List<CGameServerPropertyType> _gameServerPropertyTypes;
        private object _gameServerPropertyTypesLock = new object();

        private static readonly GameServerPropertyCache _instance = new GameServerPropertyCache();
        public static GameServerPropertyCache Instance { get { return _instance; } }

        private GameServerPropertyCache()
        {
            _gameServerProperties = new List<CGameServerProperty>();
            _gameServerPropertyTypes = new List<CGameServerPropertyType>();
        }

        public Dictionary<int, List<CGameServerProperty>> GetGameServerPlayerCache(SqlConnection conn)
        {
            var gameProperties = new List<CGameServerProperty>();
            var gamePropertyTypes = new Dictionary<int, CGameServerPropertyType>();

            var query = "SELECT GameServerProperty.ID, " +
                            "GameServerProperty.GameServerID, " +
                            "GameServerProperty.GameServerPropertyTypeID, " +
                            "GameServerProperty.Value, " +
                            "GameServerPropertyType.GameServerDataSourceID, " +
                            "GameServerPropertyType.Name, " +
                            "GameServerPropertyType.TypeName, " +
                            "GameServerPropertyType.DefaultValue " +
                        "FROM GameServerProperty WITH(NOLOCK) " +
                            "INNER JOIN GameServerPropertyType WITH(NOLOCK) ON GameServerPropertyType.ID = GameServerProperty.GameServerPropertyTypeID ";

            var cmd = new SqlCommand(query, conn);
            using (var reader = cmd.ExecuteReader())
            {
                while (reader.Read())
                {

                    var gamePropertyType = new CGameServerPropertyType();
                    gamePropertyType.SetFromDataReader(reader);

                    if (!gamePropertyTypes.ContainsKey(gamePropertyType.ID))
                    {
                        gamePropertyTypes.Add(gamePropertyType.ID, gamePropertyType);    
                    }
                    

                    var gameProperty = new CGameServerProperty();
                    gameProperty.SetFromDataReader(reader);
                    gameProperty.GameServerPropertyType = gamePropertyTypes[gameProperty.GameServerPropertyTypeID];
                    gameProperties.Add(gameProperty);

                }

                lock (_gameServerPropertiesLock)
                {
                    _gameServerProperties = gameProperties;
                }

                lock (_gameServerPropertyTypesLock)
                {
                    _gameServerPropertyTypes = gamePropertyTypes.Values.ToList();
                }

                var gamePropertiesByServerId = new Dictionary<int, List<CGameServerProperty>>();
                foreach (int gameServerId in gameProperties.Select(p => p.GameServerID).Distinct())
                {
                    gamePropertiesByServerId.Add(gameServerId, gameProperties.Where(p => p.GameServerID == gameServerId).ToList());
                }

                return gamePropertiesByServerId;
            }
        }
    }
}