﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using Curse.GameServers.Extensions;
using Curse.Extensions;
using Curse.GameServers.Configuration;

namespace Curse.GameServers.Caching
{
    public class GameServerRatingCache
    {
        private List<CGameServerRating> _gameServerRatings;
        private object _gameServerRatingsLock = new object();
        
        private static readonly GameServerRatingCache _instance = new GameServerRatingCache();
        public static GameServerRatingCache Instance { get { return _instance; } }

        private GameServerRatingCache()
        {
            _gameServerRatings = new List<CGameServerRating>();
        }

        public CServiceResponse CreateGameServerRating(string title, string description, EGameServerRatingStatus status)
        {
            using (var conn = DatabaseConfiguration.GetGameServerConnection())
            {
                var cmd = new SqlCommand("INSERT INTO GameServerRating(Title, Description, Status) VALUES(@Title, @Description, @Status)", conn);
                cmd.Parameters.Add("Title", System.Data.SqlDbType.NVarChar).Value = title;
                cmd.Parameters.Add("Description", System.Data.SqlDbType.NVarChar).Value = description;
                cmd.Parameters.Add("Status", System.Data.SqlDbType.TinyInt).Value = status;

                try
                {
                    cmd.ExecuteNonQuery();
                    return new CServiceResponse(EServiceResponseStatus.Successful);
                }
                catch (Exception exc)
                {
                    Logger.Log("Failed to create gameserver rating (Title={0}, Description={1}, Status={2}). Details: {3}", ELogLevel.Error, title, description, status, exc.GetExceptionDetails());
                    return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.Message);
                }
            }
        }

        public CServiceResponse UpdateGameServerRating(int gameServerRatingId, string title, string description, EGameServerRatingStatus status)
        {
            using (var conn = DatabaseConfiguration.GetGameServerConnection())
            {
                var cmd = new SqlCommand("UPDATE GameServerRating SET Title = @Title, Description = @Description, Status = @Status WHERE ID = @ID", conn);
                cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = gameServerRatingId;
                cmd.Parameters.Add("Title", System.Data.SqlDbType.NVarChar).Value = title;
                cmd.Parameters.Add("Description", System.Data.SqlDbType.NVarChar).Value = description;
                cmd.Parameters.Add("Status", System.Data.SqlDbType.TinyInt).Value = status;

                try
                {
                    cmd.ExecuteNonQuery();
                    return new CServiceResponse(EServiceResponseStatus.Successful);
                }
                catch (Exception exc)
                {
                    Logger.Log("Failed to update gameserver rating({0}) rating (Title={1}, Description={2}, Status={3}). Details: {4}", ELogLevel.Error, gameServerRatingId, title, description, status, exc.GetExceptionDetails());
                    return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.Message);
                }
            }
        }

        public CServiceResponse DeleteGameServerRating(int gameServerRatingId)
        {
            using (var conn = DatabaseConfiguration.GetGameServerConnection())
            {
                var cmd = new SqlCommand("spDeleteGameServerRating", conn);
                cmd.CommandType = System.Data.CommandType.StoredProcedure;
                cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = gameServerRatingId;

                try
                {
                    cmd.ExecuteNonQuery();
                    return new CServiceResponse(EServiceResponseStatus.Successful);
                }
                catch (Exception exc)
                {
                    Logger.Log("Failed to delete gameserver rating({0}). Details: {1}", ELogLevel.Error, gameServerRatingId, exc.GetExceptionDetails());
                    return new CServiceResponse(EServiceResponseStatus.UnknownException, exc.Message);
                }
            }
        }

        public List<CGameServerRating> GetGameServerRatingCache(SqlConnection conn)
        {
            var gameServerRatings = new List<CGameServerRating>();

            var query = "SELECT * FROM GameServerRating";
            var cmd = new SqlCommand(query, conn);

            using (var reader = cmd.ExecuteReader())
            {
                while (reader.Read())
                {
                    var gameServerRating = new CGameServerRating();
                    gameServerRating.SetFromDataReader(reader);

                    gameServerRatings.Add(gameServerRating);
                }

                lock (_gameServerRatingsLock)
                {
                    _gameServerRatings = gameServerRatings;
                }
                return _gameServerRatings;
            }
        }
    }
}